/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.transparency.BundleTransparencyCheckUtils;
import com.android.tools.build.bundletool.transparency.TransparencyCheckResult;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.io.ByteSource;
import java.util.Optional;

public final class CodeTransparencyValidator
extends SubValidator {
    @Override
    public void validateBundle(AppBundle bundle) {
        Optional<ByteSource> signedTransparencyFile = bundle.getBundleMetadata().getFileAsByteSource("com.android.tools.build.bundletool", "code_transparency_signed.jwt");
        if (!signedTransparencyFile.isPresent()) {
            return;
        }
        TransparencyCheckResult transparencyCheckResult = BundleTransparencyCheckUtils.checkTransparency(bundle, signedTransparencyFile.get());
        if (!transparencyCheckResult.verified()) {
            throw InvalidBundleException.builder().withUserMessage(transparencyCheckResult.getErrorMessage()).build();
        }
    }
}

