/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import java.util.concurrent.TimeUnit;

public class TimeoutRemainder {
    private final SystemNanoTimeProvider nanoTimeProvider;
    private final long timeout;
    private final TimeUnit unit;
    private final long startNanos;

    public TimeoutRemainder(long timeout, TimeUnit unit) {
        this(DefaultSystemNanoTime.getInstance(), timeout, unit);
    }

    public TimeoutRemainder(SystemNanoTimeProvider nanoTimeProvider, long timeout, TimeUnit unit) {
        this.nanoTimeProvider = nanoTimeProvider;
        this.timeout = timeout;
        this.unit = unit;
        this.startNanos = this.elapsedNanos(0L);
    }

    public long getRemainingNanos() {
        return this.unit.toNanos(this.timeout) - this.elapsedNanos(this.startNanos);
    }

    public long getRemainingUnits() {
        return this.getRemainingUnits(this.unit);
    }

    public long getRemainingUnits(TimeUnit unit) {
        return unit.convert(this.getRemainingNanos(), TimeUnit.NANOSECONDS);
    }

    private long elapsedNanos(long startNanos) {
        return this.nanoTimeProvider.nanoTime() - startNanos;
    }

    public static class DefaultSystemNanoTime
    implements SystemNanoTimeProvider {
        public static DefaultSystemNanoTime sInstance = new DefaultSystemNanoTime();

        public static DefaultSystemNanoTime getInstance() {
            return sInstance;
        }

        @Override
        public long nanoTime() {
            return System.nanoTime();
        }
    }

    public static interface SystemNanoTimeProvider {
        public long nanoTime();
    }
}

