/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.sdkmodule.DexAndResourceRepackager;
import com.android.tools.build.bundletool.xml.XmlUtils;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class RuntimeEnabledSdkTableInjector {
    @VisibleForTesting
    public static final String RUNTIME_ENABLED_SDK_TABLE_FILE_PATH = "assets/RuntimeEnabledSdkTable.xml";
    private static final String RUNTIME_ENABLED_SDK_TABLE_ELEMENT_NAME = "runtime-enabled-sdk-table";
    private static final String RUNTIME_ENABELD_SDK_ELEMENT_NAME = "runtime-enabled-sdk";
    private static final String SDK_PACKAGE_NAME_ELEMENT_NAME = "package-name";
    private static final String COMPAT_CONFIG_PATH_ELEMENT_NAME = "compat-config-path";
    private final AppBundle appBundle;

    public RuntimeEnabledSdkTableInjector(AppBundle appBundle) {
        this.appBundle = appBundle;
    }

    public ModuleSplit inject(ModuleSplit split) {
        if (this.appBundle.getRuntimeEnabledSdkDependencies().isEmpty() || !this.shouldAddRuntimeEnabledSdkTable(split)) {
            return split;
        }
        return split.toBuilder().addEntry(ModuleEntry.builder().setPath(ZipPath.create(RUNTIME_ENABLED_SDK_TABLE_FILE_PATH)).setContent(ByteSource.wrap(XmlUtils.documentToString(this.getRuntimeEnabledSdkTable((ImmutableSet<String>)this.appBundle.getRuntimeEnabledSdkDependencies().keySet())).getBytes(StandardCharsets.UTF_8))).build()).build();
    }

    private boolean shouldAddRuntimeEnabledSdkTable(ModuleSplit split) {
        return !split.getVariantTargeting().getSdkRuntimeTargeting().getRequiresSdkRuntime() && (split.getSplitType() == ModuleSplit.SplitType.STANDALONE || split.isMasterSplit() && split.isBaseModuleSplit());
    }

    private Document getRuntimeEnabledSdkTable(ImmutableSet<String> sdkPackageNames) {
        Document runtimeEnabledSdkTable;
        try {
            runtimeEnabledSdkTable = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e11) {
            throw new IllegalStateException(e11);
        }
        runtimeEnabledSdkTable.appendChild(this.createRuntimeEnabledSdkTableNode(runtimeEnabledSdkTable, sdkPackageNames));
        return runtimeEnabledSdkTable;
    }

    private Node createRuntimeEnabledSdkTableNode(Document xmlFactory, ImmutableSet<String> sdkPackageNames) {
        Element runtimeEnabledSdkTableNode = xmlFactory.createElement(RUNTIME_ENABLED_SDK_TABLE_ELEMENT_NAME);
        sdkPackageNames.forEach(sdkPackageName -> runtimeEnabledSdkTableNode.appendChild(this.createRuntimeEnabledSdkNode(xmlFactory, (String)sdkPackageName)));
        return runtimeEnabledSdkTableNode;
    }

    private Node createRuntimeEnabledSdkNode(Document xmlFactory, String sdkPackageName) {
        Element runtimeEnabledSdkNode = xmlFactory.createElement(RUNTIME_ENABELD_SDK_ELEMENT_NAME);
        Element sdkPackageNameNode = xmlFactory.createElement(SDK_PACKAGE_NAME_ELEMENT_NAME);
        sdkPackageNameNode.setTextContent(sdkPackageName);
        Element compatConfigPathNode = xmlFactory.createElement(COMPAT_CONFIG_PATH_ELEMENT_NAME);
        compatConfigPathNode.setTextContent(DexAndResourceRepackager.getCompatSdkConfigPathInAssets(sdkPackageName));
        runtimeEnabledSdkNode.appendChild(sdkPackageNameNode);
        runtimeEnabledSdkNode.appendChild(compatConfigPathNode);
        return runtimeEnabledSdkNode;
    }
}

