/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.validation.SubValidator;

public class SdkBundleModuleResourceIdValidator
extends SubValidator {
    public static final int SDK_BUNDLE_PACKAGE_ID = 127;

    @Override
    public void validateModule(BundleModule module) {
        Resources.ResourceTable resourceTable = module.getResourceTable().orElse(Resources.ResourceTable.getDefaultInstance());
        resourceTable.getPackageList().forEach(aPackage -> {
            if (aPackage.getPackageId().getId() != 127) {
                throw InvalidBundleException.builder().withUserMessage("SDK Bundle Resource IDs must be in the %s space.", Integer.toHexString(127)).build();
            }
        });
    }
}

