/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.io;

import com.android.bundle.Commands;
import com.android.bundle.Config;
import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.commands.BuildApksCommand;
import com.android.tools.build.bundletool.commands.BuildApksModule;
import com.android.tools.build.bundletool.device.ApkMatcher;
import com.android.tools.build.bundletool.io.ApkPathManager;
import com.android.tools.build.bundletool.io.ApkSerializer;
import com.android.tools.build.bundletool.io.ApkSetWriter;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.ApkModifier;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.Bundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.GeneratedApks;
import com.android.tools.build.bundletool.model.GeneratedAssetSlices;
import com.android.tools.build.bundletool.model.ManifestDeliveryElement;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.model.VariantKey;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.utils.CollectorUtils;
import com.android.tools.build.bundletool.model.version.BundleToolVersion;
import com.android.tools.build.bundletool.optimizations.ApkOptimizations;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.protobuf.Int32Value;
import com.google.protobuf.StringValue;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class ApkSerializerManager {
    private final Bundle bundle;
    private final ApkModifier apkModifier;
    private final int firstVariantNumber;
    private final BuildApksCommand.ApkBuildMode apkBuildMode;
    private final ApkPathManager apkPathManager;
    private final ApkOptimizations apkOptimizations;
    private final ApkSerializer apkSerializer;

    @Inject
    public ApkSerializerManager(Bundle bundle, Optional<ApkModifier> apkModifier, @BuildApksModule.FirstVariantNumber Optional<Integer> firstVariantNumber, @BuildApksModule.VerboseLogs boolean verbose, BuildApksCommand.ApkBuildMode apkBuildMode, ApkPathManager apkPathManager, ApkOptimizations apkOptimizations, ApkSerializer apkSerializer) {
        this.bundle = bundle;
        this.apkModifier = apkModifier.orElse(ApkModifier.NO_OP);
        this.firstVariantNumber = firstVariantNumber.orElse(0);
        this.apkBuildMode = apkBuildMode;
        this.apkPathManager = apkPathManager;
        this.apkOptimizations = apkOptimizations;
        this.apkSerializer = apkSerializer;
    }

    public Commands.BuildApksResult serializeApkSet(ApkSetWriter apkSetWriter, GeneratedApks generatedApks, GeneratedAssetSlices generatedAssetSlices, Optional<Devices.DeviceSpec> deviceSpec, Commands.LocalTestingInfo localTestingInfo, ImmutableSet<BundleModuleName> permanentlyFusedModules) {
        try {
            Commands.BuildApksResult toc = this.serializeApkSetContent(apkSetWriter.getSplitsDirectory(), generatedApks, generatedAssetSlices, deviceSpec, localTestingInfo, permanentlyFusedModules);
            apkSetWriter.writeApkSet(toc);
            return toc;
        }
        catch (IOException e11) {
            throw new UncheckedIOException(e11);
        }
    }

    public void serializeSdkApkSet(ApkSetWriter apkSetWriter, GeneratedApks generatedApks) {
        try {
            Commands.BuildSdkApksResult toc = this.serializeSdkApkSetContent(apkSetWriter.getSplitsDirectory(), generatedApks);
            apkSetWriter.writeApkSet(toc);
        }
        catch (IOException e11) {
            throw new UncheckedIOException(e11);
        }
    }

    private Commands.BuildApksResult serializeApkSetContent(Path outputDirectory, GeneratedApks generatedApks, GeneratedAssetSlices generatedAssetSlices, Optional<Devices.DeviceSpec> deviceSpec, Commands.LocalTestingInfo localTestingInfo, ImmutableSet<BundleModuleName> permanentlyFusedModules) {
        ImmutableList<Commands.Variant> allVariantsWithTargeting = this.serializeApks(outputDirectory, generatedApks, deviceSpec);
        ImmutableList<Commands.AssetSliceSet> allAssetSliceSets = this.serializeAssetSlices(outputDirectory, generatedAssetSlices, deviceSpec);
        Commands.BuildApksResult.Builder apksResult = Commands.BuildApksResult.newBuilder().setPackageName(this.bundle.getPackageName()).addAllVariant(allVariantsWithTargeting).setBundletool(Config.Bundletool.newBuilder().setVersion(BundleToolVersion.getCurrentVersion().toString())).addAllAssetSliceSet(allAssetSliceSets).setLocalTestingInfo(localTestingInfo);
        Config.BundleConfig bundleConfig = ((AppBundle)this.bundle).getBundleConfig();
        if (bundleConfig.hasAssetModulesConfig()) {
            apksResult.setAssetModulesInfo(ApkSerializerManager.getAssetModulesInfo(bundleConfig.getAssetModulesConfig()));
        }
        apksResult.addAllDefaultTargetingValue(ApkSerializerManager.getDefaultTargetingValues(bundleConfig));
        permanentlyFusedModules.forEach(moduleName -> apksResult.addPermanentlyFusedModules(Commands.PermanentlyFusedModule.newBuilder().setName(moduleName.getName())));
        return apksResult.build();
    }

    private Commands.BuildSdkApksResult serializeSdkApkSetContent(Path outputDirectory, GeneratedApks generatedApks) {
        ImmutableList<Commands.Variant> allVariantsWithTargeting = this.serializeApks(outputDirectory, generatedApks, Optional.empty());
        SdkBundle sdkBundle = (SdkBundle)this.bundle;
        Preconditions.checkState(sdkBundle.getVersionCode().isPresent(), "Missing version code for SDK Bundle.");
        return Commands.BuildSdkApksResult.newBuilder().setPackageName(sdkBundle.getPackageName()).addAllVariant(allVariantsWithTargeting).setBundletool(Config.Bundletool.newBuilder().setVersion(BundleToolVersion.getCurrentVersion().toString())).setVersion(Commands.SdkVersionInformation.newBuilder().setVersionCode(sdkBundle.getVersionCode().get()).setMajor(sdkBundle.getMajorVersion()).setMinor(sdkBundle.getMinorVersion()).setPatch(sdkBundle.getPatchVersion()).build()).build();
    }

    @VisibleForTesting
    ImmutableList<Commands.Variant> serializeApks(Path outputDirectory, GeneratedApks generatedApks, Optional<Devices.DeviceSpec> deviceSpec) {
        ApkSerializerManager.validateInput(generatedApks, this.apkBuildMode);
        Predicate deviceFilter = deviceSpec.isPresent() && !this.apkBuildMode.equals((Object)BuildApksCommand.ApkBuildMode.SYSTEM) ? new ApkMatcher(this.addDefaultCountrySetIfNecessary(this.addDefaultDeviceTierIfNecessary(deviceSpec.get())))::matchesModuleSplitByTargeting : Predicates.alwaysTrue();
        ImmutableListMultimap<VariantKey, ModuleSplit> splitsByVariant = generatedApks.getAllApksGroupedByOrderedVariants();
        AtomicInteger variantNumberCounter = new AtomicInteger(this.firstVariantNumber);
        ImmutableMap variantNumberByVariantKey = splitsByVariant.keySet().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), unused -> variantNumberCounter.getAndIncrement()));
        ImmutableListMultimap<VariantKey, ModuleSplit> finalSplitsByVariant = splitsByVariant.entries().stream().filter(keyModuleSplitEntry -> deviceFilter.test((ModuleSplit)keyModuleSplitEntry.getValue())).collect(CollectorUtils.groupingBySortedKeys(Map.Entry::getKey, entry -> ApkSerializerManager.clearVariantTargeting(this.modifyApk((ModuleSplit)entry.getValue(), (Integer)variantNumberByVariantKey.get(entry.getKey())))));
        ImmutableBiMap<ZipPath, ModuleSplit> splitsByRelativePath = finalSplitsByVariant.values().stream().distinct().collect(ImmutableBiMap.toImmutableBiMap(this.apkPathManager::getApkPath, Function.identity()));
        ImmutableMap<ZipPath, Commands.ApkDescription> apkDescriptionsByRelativePath = this.apkSerializer.serialize(outputDirectory, splitsByRelativePath);
        ImmutableList.Builder variants = ImmutableList.builder();
        for (VariantKey variantKey : finalSplitsByVariant.keySet()) {
            Commands.Variant.Builder variant = Commands.Variant.newBuilder().setVariantNumber(variantNumberByVariantKey.get(variantKey)).setTargeting(variantKey.getVariantTargeting()).setVariantProperties(this.getVariantProperties((ImmutableList<ModuleSplit>)finalSplitsByVariant.get((Object)variantKey)));
            Multimap splitsByModuleName = finalSplitsByVariant.get((Object)variantKey).stream().collect(CollectorUtils.groupingBySortedKeys(ModuleSplit::getModuleName));
            for (BundleModuleName moduleName : splitsByModuleName.keySet()) {
                variant.addApkSet(Commands.ApkSet.newBuilder().setModuleMetadata(this.bundle.getModule(moduleName).getModuleMetadata(variant.getTargeting().getSdkRuntimeTargeting().getRequiresSdkRuntime())).addAllApkDescription(splitsByModuleName.get(moduleName).stream().map(split -> (ZipPath)((ImmutableMap)((Object)splitsByRelativePath.inverse())).get(split)).map(apkDescriptionsByRelativePath::get).collect(ImmutableList.toImmutableList())));
            }
            variants.add(variant.build());
        }
        return variants.build();
    }

    @VisibleForTesting
    ImmutableList<Commands.AssetSliceSet> serializeAssetSlices(Path outputDirectory, GeneratedAssetSlices generatedAssetSlices, Optional<Devices.DeviceSpec> deviceSpec) {
        Predicate deviceFilter = deviceSpec.isPresent() ? new ApkMatcher(this.addDefaultCountrySetIfNecessary(this.addDefaultDeviceTierIfNecessary(deviceSpec.get())))::matchesModuleSplitByTargeting : Predicates.alwaysTrue();
        ImmutableMap<ZipPath, ModuleSplit> assetSplitsByRelativePath = generatedAssetSlices.getAssetSlices().stream().filter(deviceFilter).collect(ImmutableMap.toImmutableMap(this.apkPathManager::getApkPath, Function.identity()));
        ImmutableMap<ZipPath, Commands.ApkDescription> apkDescriptionsByRelativePath = this.apkSerializer.serialize(outputDirectory, assetSplitsByRelativePath);
        ImmutableMap serializedApksByModuleName = assetSplitsByRelativePath.keySet().stream().collect(CollectorUtils.groupingByDeterministic(relativePath -> ((ModuleSplit)assetSplitsByRelativePath.get(relativePath)).getModuleName(), Collectors.mapping(apkDescriptionsByRelativePath::get, ImmutableList.toImmutableList())));
        return serializedApksByModuleName.entrySet().stream().map(entry -> Commands.AssetSliceSet.newBuilder().setAssetModuleMetadata(this.getAssetModuleMetadata(this.bundle.getModule((BundleModuleName)entry.getKey()))).addAllApkDescription((Iterable)entry.getValue()).build()).collect(ImmutableList.toImmutableList());
    }

    private Commands.VariantProperties getVariantProperties(ImmutableList<ModuleSplit> modules) {
        ImmutableList nativeLibEntries = modules.stream().filter(module -> module.getNativeConfig().isPresent()).flatMap(module -> module.getNativeConfig().get().getDirectoryList().stream().flatMap(dir -> module.findEntriesUnderPath(dir.getPath()))).collect(ImmutableList.toImmutableList());
        ImmutableList dexEntries = modules.stream().flatMap(module -> module.getEntries().stream()).filter(entry -> entry.getPath().startsWith(BundleModule.DEX_DIRECTORY)).collect(ImmutableList.toImmutableList());
        return Commands.VariantProperties.newBuilder().setUncompressedDex(!dexEntries.isEmpty() && dexEntries.stream().allMatch(ModuleEntry::getForceUncompressed)).setUncompressedNativeLibraries(!nativeLibEntries.isEmpty() && nativeLibEntries.stream().allMatch(ModuleEntry::getForceUncompressed)).setSparseEncoding(modules.stream().allMatch(ModuleSplit::getSparseEncoding)).build();
    }

    private Commands.AssetModuleMetadata getAssetModuleMetadata(BundleModule module) {
        AndroidManifest manifest = module.getAndroidManifest();
        Commands.AssetModuleMetadata.Builder metadataBuilder = Commands.AssetModuleMetadata.newBuilder().setName(module.getName().getName());
        Optional<ManifestDeliveryElement> persistentDelivery = manifest.getManifestDeliveryElement();
        metadataBuilder.setDeliveryType(persistentDelivery.map(delivery -> ApkSerializerManager.getDeliveryType(delivery)).orElse(Commands.DeliveryType.INSTALL_TIME));
        boolean isInstantModule = module.isInstantModule();
        Commands.InstantMetadata.Builder instantMetadataBuilder = Commands.InstantMetadata.newBuilder().setIsInstant(isInstantModule);
        Optional<ManifestDeliveryElement> instantDelivery = manifest.getInstantManifestDeliveryElement();
        if (isInstantModule) {
            instantMetadataBuilder.setDeliveryType(instantDelivery.map(delivery -> ApkSerializerManager.getDeliveryType(delivery)).orElse(Commands.DeliveryType.ON_DEMAND));
        }
        metadataBuilder.setInstantMetadata(instantMetadataBuilder.build());
        return metadataBuilder.build();
    }

    private static void validateInput(GeneratedApks generatedApks, BuildApksCommand.ApkBuildMode apkBuildMode) {
        switch (apkBuildMode) {
            case DEFAULT: {
                Preconditions.checkArgument(generatedApks.getSystemApks().isEmpty(), "Internal error: System APKs can only be set in system mode.");
                break;
            }
            case UNIVERSAL: {
                Preconditions.checkArgument(generatedApks.getSplitApks().isEmpty() && generatedApks.getInstantApks().isEmpty() && generatedApks.getArchivedApks().isEmpty() && generatedApks.getSystemApks().isEmpty(), "Internal error: For universal APK expecting only standalone APKs.");
                break;
            }
            case SYSTEM: {
                Preconditions.checkArgument(generatedApks.getSplitApks().isEmpty() && generatedApks.getInstantApks().isEmpty() && generatedApks.getArchivedApks().isEmpty() && generatedApks.getStandaloneApks().isEmpty(), "Internal error: For system mode expecting only system APKs.");
                break;
            }
            case PERSISTENT: {
                Preconditions.checkArgument(generatedApks.getSystemApks().isEmpty(), "Internal error: System APKs not expected with persistent mode.");
                Preconditions.checkArgument(generatedApks.getInstantApks().isEmpty(), "Internal error: Instant APKs not expected with persistent mode.");
                break;
            }
            case INSTANT: {
                Preconditions.checkArgument(generatedApks.getSystemApks().isEmpty(), "Internal error: System APKs not expected with instant mode.");
                Preconditions.checkArgument(generatedApks.getSplitApks().isEmpty() && generatedApks.getStandaloneApks().isEmpty(), "Internal error: Persistent APKs not expected with instant mode.");
                break;
            }
            case ARCHIVE: {
                Preconditions.checkArgument(generatedApks.getSplitApks().isEmpty() && generatedApks.getInstantApks().isEmpty() && generatedApks.getStandaloneApks().isEmpty() && generatedApks.getSystemApks().isEmpty(), "Internal error: For archive mode expecting only archived APKs.");
            }
        }
    }

    private ModuleSplit modifyApk(ModuleSplit moduleSplit, int variantNumber) {
        ApkModifier.ApkDescription apkDescription = ApkModifier.ApkDescription.builder().setBase(moduleSplit.isBaseModuleSplit()).setApkType(moduleSplit.getSplitType().equals((Object)ModuleSplit.SplitType.STANDALONE) ? ApkModifier.ApkDescription.ApkType.STANDALONE : (moduleSplit.isMasterSplit() ? ApkModifier.ApkDescription.ApkType.MASTER_SPLIT : ApkModifier.ApkDescription.ApkType.CONFIG_SPLIT)).setVariantNumber(variantNumber).setVariantTargeting(moduleSplit.getVariantTargeting()).setApkTargeting(moduleSplit.getApkTargeting()).build();
        return moduleSplit.toBuilder().setAndroidManifest(this.apkModifier.modifyManifest(moduleSplit.getAndroidManifest(), apkDescription)).build();
    }

    private static ModuleSplit clearVariantTargeting(ModuleSplit moduleSplit) {
        return moduleSplit.toBuilder().setVariantTargeting(Targeting.VariantTargeting.getDefaultInstance()).build();
    }

    private static Commands.AssetModulesInfo getAssetModulesInfo(Config.AssetModulesConfig assetModulesConfig) {
        return Commands.AssetModulesInfo.newBuilder().addAllAppVersion(assetModulesConfig.getAppVersionList()).setAssetVersionTag(assetModulesConfig.getAssetVersionTag()).build();
    }

    private static ImmutableList<Commands.DefaultTargetingValue> getDefaultTargetingValues(Config.BundleConfig bundleConfig) {
        return bundleConfig.getOptimizations().getSplitsConfig().getSplitDimensionList().stream().filter(Config.SplitDimension::hasSuffixStripping).map(splitDimension -> Commands.DefaultTargetingValue.newBuilder().setDimension(splitDimension.getValue()).setDefaultValue(splitDimension.getSuffixStripping().getDefaultSuffix()).build()).collect(ImmutableList.toImmutableList());
    }

    private static Commands.DeliveryType getDeliveryType(ManifestDeliveryElement deliveryElement) {
        if (deliveryElement.hasOnDemandElement()) {
            return Commands.DeliveryType.ON_DEMAND;
        }
        if (deliveryElement.hasFastFollowElement()) {
            return Commands.DeliveryType.FAST_FOLLOW;
        }
        return Commands.DeliveryType.INSTALL_TIME;
    }

    private Devices.DeviceSpec addDefaultDeviceTierIfNecessary(Devices.DeviceSpec deviceSpec) {
        if (deviceSpec.hasDeviceTier()) {
            return deviceSpec;
        }
        Optional<Config.SuffixStripping> deviceTierSuffix = Optional.ofNullable(this.apkOptimizations.getSuffixStrippings().get((Object)OptimizationDimension.DEVICE_TIER));
        if (!deviceTierSuffix.isPresent()) {
            return deviceSpec;
        }
        return deviceSpec.toBuilder().setDeviceTier(Int32Value.of(deviceTierSuffix.map(suffix -> suffix.getDefaultSuffix().isEmpty() ? 0 : Integer.parseInt(suffix.getDefaultSuffix())).orElse(0))).build();
    }

    private Devices.DeviceSpec addDefaultCountrySetIfNecessary(Devices.DeviceSpec deviceSpec) {
        if (deviceSpec.hasCountrySet()) {
            return deviceSpec;
        }
        Optional<Config.SuffixStripping> countrySetSuffix = Optional.ofNullable(this.apkOptimizations.getSuffixStrippings().get((Object)OptimizationDimension.COUNTRY_SET));
        if (!countrySetSuffix.isPresent()) {
            return deviceSpec;
        }
        return deviceSpec.toBuilder().setCountrySet(StringValue.of(countrySetSuffix.map(Config.SuffixStripping::getDefaultSuffix).orElse(""))).build();
    }
}

