/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.device.iap.model;

import com.amazon.device.iap.internal.model.ReceiptBuilder;
import com.amazon.device.iap.internal.util.d;
import com.amazon.device.iap.model.ProductType;
import java.util.Date;
import org.json.JSONException;
import org.json.JSONObject;

public final class Receipt {
    private static final Date DATE_CANCELED = new Date(1L);
    private static final String RECEIPT_ID = "receiptId";
    private static final String SKU = "sku";
    private static final String PRODUCT_TYPE = "itemType";
    private static final String PURCHASE_DATE = "purchaseDate";
    private static final String CANCEL_DATE = "endDate";
    private final String receiptId;
    private final String sku;
    private final ProductType productType;
    private final Date purchaseDate;
    private final Date cancelDate;

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + (this.cancelDate == null ? 0 : this.cancelDate.hashCode());
        n2 = 31 * n2 + (this.productType == null ? 0 : this.productType.hashCode());
        n2 = 31 * n2 + (this.purchaseDate == null ? 0 : this.purchaseDate.hashCode());
        n2 = 31 * n2 + (this.receiptId == null ? 0 : this.receiptId.hashCode());
        n2 = 31 * n2 + (this.sku == null ? 0 : this.sku.hashCode());
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Receipt receipt = (Receipt)object;
        if (this.cancelDate == null ? receipt.cancelDate != null : !this.cancelDate.equals(receipt.cancelDate)) {
            return false;
        }
        if (this.productType != receipt.productType) {
            return false;
        }
        if (this.purchaseDate == null ? receipt.purchaseDate != null : !this.purchaseDate.equals(receipt.purchaseDate)) {
            return false;
        }
        if (this.receiptId == null ? receipt.receiptId != null : !this.receiptId.equals(receipt.receiptId)) {
            return false;
        }
        return !(this.sku == null ? receipt.sku != null : !this.sku.equals(receipt.sku));
    }

    public Receipt(ReceiptBuilder receiptBuilder) {
        d.a((Object)receiptBuilder.getSku(), SKU);
        d.a((Object)receiptBuilder.getProductType(), "productType");
        if (ProductType.SUBSCRIPTION == receiptBuilder.getProductType()) {
            d.a(receiptBuilder.getPurchaseDate(), PURCHASE_DATE);
        }
        this.receiptId = receiptBuilder.getReceiptId();
        this.sku = receiptBuilder.getSku();
        this.productType = receiptBuilder.getProductType();
        this.purchaseDate = receiptBuilder.getPurchaseDate();
        this.cancelDate = receiptBuilder.getCancelDate();
    }

    public String getReceiptId() {
        return this.receiptId;
    }

    public String getSku() {
        return this.sku;
    }

    public ProductType getProductType() {
        return this.productType;
    }

    public Date getPurchaseDate() {
        return this.purchaseDate;
    }

    public Date getCancelDate() {
        return this.cancelDate;
    }

    public JSONObject toJSON() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(RECEIPT_ID, (Object)this.receiptId);
            jSONObject.put(SKU, (Object)this.sku);
            jSONObject.put(PRODUCT_TYPE, (Object)this.productType);
            jSONObject.put(PURCHASE_DATE, (Object)this.purchaseDate);
            jSONObject.put(CANCEL_DATE, (Object)this.cancelDate);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public String toString() {
        String string = null;
        try {
            string = this.toJSON().toString(4);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return string;
    }

    public boolean isCanceled() {
        return this.cancelDate != null;
    }
}

