/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.validation.BundleValidationUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;

public class EntryClashValidator
extends SubValidator {
    @Override
    public void validateAllModules(ImmutableList<BundleModule> modules) {
        BundleModule baseModule;
        boolean isolatedSplits;
        if (!BundleValidationUtils.isAssetOnlyBundle(modules) && (isolatedSplits = (baseModule = BundleValidationUtils.expectBaseModule(modules)).getAndroidManifest().getIsolatedSplits().orElse(false).booleanValue())) {
            return;
        }
        EntryClashValidator.checkEntryClashes(modules);
    }

    @VisibleForTesting
    static void checkEntryClashes(ImmutableList<BundleModule> modules) {
        HashMap usedPaths = new HashMap();
        for (BundleModule module : modules) {
            module.getEntries().stream().filter(Predicates.not(EntryClashValidator::isExpectedToBeDifferent)).forEach(entry -> {
                BundleModule otherModuleWithPath = usedPaths.putIfAbsent(entry.getPath(), module);
                if (otherModuleWithPath != null) {
                    EntryClashValidator.checkEntryClash(entry.getPath(), otherModuleWithPath, module);
                }
            });
        }
    }

    private static boolean isExpectedToBeDifferent(ModuleEntry entry) {
        return entry.getPath().startsWith(BundleModule.DEX_DIRECTORY);
    }

    private static void checkEntryClash(ZipPath path, BundleModule module1, BundleModule module2) {
        if (BundleModule.ModuleType.ASSET_MODULE.equals((Object)module1.getModuleType()) ^ BundleModule.ModuleType.ASSET_MODULE.equals((Object)module2.getModuleType())) {
            throw InvalidBundleException.builder().withUserMessage("Both modules '%s' and '%s' contain asset entry '%s'.", module1.getName(), module2.getName(), path).build();
        }
        EntryClashValidator.checkEqualEntries(path, module1, module2);
    }

    private static void checkEqualEntries(ZipPath path, BundleModule module1, BundleModule module2) {
        ModuleEntry entry2;
        ModuleEntry entry1 = module1.getEntry(path).get();
        if (!entry1.equals(entry2 = module2.getEntry(path).get())) {
            throw InvalidBundleException.builder().withUserMessage("Modules '%s' and '%s' contain entry '%s' with different content.", module1.getName(), module2.getName(), path).build();
        }
    }
}

