/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleDeliveryType;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.model.version.VersionGuardedFeature;
import com.android.tools.build.bundletool.validation.BundleValidationUtils;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;

public class ModuleTitleValidator
extends SubValidator {
    @Override
    public void validateAllModules(ImmutableList<BundleModule> modules) {
        ModuleTitleValidator.checkModuleTitles(modules);
    }

    private static void checkModuleTitles(ImmutableList<BundleModule> modules) {
        if (BundleValidationUtils.isAssetOnlyBundle(modules)) {
            return;
        }
        BundleModule baseModule = BundleValidationUtils.expectBaseModule(modules);
        boolean isolatedSplits = baseModule.getAndroidManifest().getIsolatedSplits().orElse(false);
        Version bundletoolVersion = baseModule.getBundletoolVersion();
        if (!VersionGuardedFeature.MODULE_TITLE_VALIDATION_ENFORCED.enabledForVersion(bundletoolVersion)) {
            return;
        }
        Resources.ResourceTable table = baseModule.getResourceTable().orElse(Resources.ResourceTable.getDefaultInstance());
        ImmutableSet stringResourceIds = ResourcesUtils.entries(table).filter(entry -> entry.getType().getName().equals("string")).map(entry -> entry.getResourceId().getFullResourceId()).collect(ImmutableSet.toImmutableSet());
        for (BundleModule module : modules) {
            if (module.getModuleType().equals((Object)BundleModule.ModuleType.ASSET_MODULE)) {
                if (!module.getAndroidManifest().getTitleRefId().isPresent()) continue;
                throw InvalidBundleException.builder().withUserMessage("Module titles not supported in asset packs, but found in '%s'.", module.getName()).build();
            }
            if (module.getDeliveryType().equals((Object)ModuleDeliveryType.ALWAYS_INITIAL_INSTALL)) continue;
            Optional<Integer> titleRefId = module.getAndroidManifest().getTitleRefId();
            if (isolatedSplits) {
                return;
            }
            if (!titleRefId.isPresent()) {
                throw InvalidBundleException.builder().withUserMessage("Mandatory title is missing in manifest for module '%s'.", module.getName()).build();
            }
            if (stringResourceIds.contains(titleRefId.get())) continue;
            throw InvalidBundleException.builder().withUserMessage("Title for module '%s' is missing in the base resource table.", module.getName()).build();
        }
    }
}

