/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.bundle.Config;
import com.android.bundle.SdkBundleConfigProto;
import com.android.bundle.SdkModulesConfigOuterClass;
import com.android.tools.build.bundletool.model.AutoValue_SdkBundle;
import com.android.tools.build.bundletool.model.Bundle;
import com.android.tools.build.bundletool.model.BundleMetadata;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.model.RuntimeEnabledSdkVersionEncoder;
import com.android.tools.build.bundletool.model.utils.BundleParser;
import com.android.tools.build.bundletool.model.version.Version;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.ByteSource;
import com.google.errorprone.annotations.Immutable;
import java.util.Optional;
import java.util.zip.ZipFile;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class SdkBundle
implements Bundle {
    public static SdkBundle buildFromZip(ZipFile bundleFile, ZipFile modulesFile, Integer versionCode) {
        SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig = BundleParser.readSdkModulesConfig(modulesFile);
        SdkBundleConfigProto.SdkBundleConfig sdkBundleConfig = BundleParser.readSdkBundleConfig(bundleFile);
        Optional<ByteSource> sdkInterfaceDescriptors = BundleParser.readSdkInterfaceDescriptors(bundleFile);
        Builder bundle = SdkBundle.builder().setModule((BundleModule)BundleParser.sanitize(BundleParser.extractModules(modulesFile, Config.BundleConfig.BundleType.REGULAR, Version.of(sdkModulesConfig.getBundletool().getVersion()), Optional.empty(), ImmutableSet.of())).get(0)).setSdkModulesConfig(sdkModulesConfig).setSdkBundleConfig(sdkBundleConfig).setBundleMetadata(BundleParser.readBundleMetadata(bundleFile)).setVersionCode(versionCode);
        sdkInterfaceDescriptors.ifPresent(bundle::setSdkInterfaceDescriptors);
        return bundle.build();
    }

    public abstract BundleModule getModule();

    @Override
    public BundleModule getModule(BundleModuleName moduleName) {
        Preconditions.checkState(this.getModule().getName().equals(moduleName), "Module '%s' not found.", (Object)moduleName);
        return this.getModule();
    }

    @Override
    public ImmutableMap<BundleModuleName, BundleModule> getModules() {
        BundleModule module = this.getModule();
        return ImmutableMap.of(module.getName(), module);
    }

    public abstract SdkModulesConfigOuterClass.SdkModulesConfig getSdkModulesConfig();

    public abstract SdkBundleConfigProto.SdkBundleConfig getSdkBundleConfig();

    @Override
    public abstract BundleMetadata getBundleMetadata();

    public abstract Optional<Integer> getVersionCode();

    public abstract Optional<ByteSource> getSdkInterfaceDescriptors();

    public Version getBundletoolVersion() {
        return Version.of(this.getSdkModulesConfig().getBundletool().getVersion());
    }

    @Override
    public String getPackageName() {
        return this.getSdkModulesConfig().getSdkPackageName();
    }

    public int getMajorVersion() {
        return this.getSdkModulesConfig().getSdkVersion().getMajor();
    }

    public int getMinorVersion() {
        return this.getSdkModulesConfig().getSdkVersion().getMinor();
    }

    public int getPatchVersion() {
        return this.getSdkModulesConfig().getSdkVersion().getPatch();
    }

    public String getProviderClassName() {
        return this.getSdkModulesConfig().getSdkProviderClassName();
    }

    public Optional<String> getCompatProviderClassName() {
        return this.getSdkModulesConfig().getCompatSdkProviderClassName().isEmpty() ? Optional.empty() : Optional.of(this.getSdkModulesConfig().getCompatSdkProviderClassName());
    }

    public int getSdkAndroidVersionMajor() {
        return RuntimeEnabledSdkVersionEncoder.encodeSdkMajorAndMinorVersion(this.getMajorVersion(), this.getMinorVersion());
    }

    public String getVersionName() {
        return this.getMajorVersion() + "." + this.getMinorVersion() + "." + this.getPatchVersion();
    }

    public String getManifestPackageName() {
        return this.getPackageName() + "_" + this.getSdkAndroidVersionMajor();
    }

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_SdkBundle.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setModule(BundleModule var1);

        public abstract Builder setSdkModulesConfig(SdkModulesConfigOuterClass.SdkModulesConfig var1);

        public abstract Builder setSdkBundleConfig(SdkBundleConfigProto.SdkBundleConfig var1);

        public abstract Builder setBundleMetadata(BundleMetadata var1);

        public abstract Builder setVersionCode(Integer var1);

        public abstract Builder setSdkInterfaceDescriptors(ByteSource var1);

        public abstract SdkBundle build();
    }
}

