/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.regex;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.checkerframework.checker.index.qual.GTENegativeOne;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.regex.qual.Regex;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.EnsuresQualifierIf;

public final class RegexUtil {
    private RegexUtil() {
        throw new Error("do not instantiate");
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static boolean isRegex(String s11) {
        return RegexUtil.isRegex(s11, 0);
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static boolean isRegex(String s11, int groups2) {
        Pattern p11;
        try {
            p11 = Pattern.compile(s11);
        }
        catch (PatternSyntaxException e11) {
            return false;
        }
        return RegexUtil.getGroupCount(p11) >= groups2;
    }

    @Pure
    @EnsuresQualifierIf(result=true, expression={"#1"}, qualifier=Regex.class)
    public static boolean isRegex(char c11) {
        return RegexUtil.isRegex(Character.toString(c11));
    }

    @SideEffectFree
    public static @Nullable String regexError(String s11) {
        return RegexUtil.regexError(s11, 0);
    }

    @SideEffectFree
    public static @Nullable String regexError(String s11, int groups2) {
        try {
            Pattern p11 = Pattern.compile(s11);
            int actualGroups = RegexUtil.getGroupCount(p11);
            if (actualGroups < groups2) {
                return RegexUtil.regexErrorMessage(s11, groups2, actualGroups);
            }
        }
        catch (PatternSyntaxException e11) {
            return e11.getMessage();
        }
        return null;
    }

    @SideEffectFree
    public static @Nullable PatternSyntaxException regexException(String s11) {
        return RegexUtil.regexException(s11, 0);
    }

    @SideEffectFree
    public static @Nullable PatternSyntaxException regexException(String s11, int groups2) {
        try {
            Pattern p11 = Pattern.compile(s11);
            int actualGroups = RegexUtil.getGroupCount(p11);
            if (actualGroups < groups2) {
                return new PatternSyntaxException(RegexUtil.regexErrorMessage(s11, groups2, actualGroups), s11, -1);
            }
        }
        catch (PatternSyntaxException pse) {
            return pse;
        }
        return null;
    }

    @SideEffectFree
    public static @Regex String asRegex(String s11) {
        return RegexUtil.asRegex(s11, 0);
    }

    @SideEffectFree
    public static @Regex String asRegex(String s11, int groups2) {
        try {
            Pattern p11 = Pattern.compile(s11);
            int actualGroups = RegexUtil.getGroupCount(p11);
            if (actualGroups < groups2) {
                throw new Error(RegexUtil.regexErrorMessage(s11, groups2, actualGroups));
            }
            return s11;
        }
        catch (PatternSyntaxException e11) {
            throw new Error(e11);
        }
    }

    @SideEffectFree
    private static String regexErrorMessage(String s11, int expectedGroups, int actualGroups) {
        return "regex \"" + s11 + "\" has " + actualGroups + " groups, but " + expectedGroups + " groups are needed.";
    }

    @Pure
    private static int getGroupCount(Pattern p11) {
        return p11.matcher("").groupCount();
    }

    public static class CheckedPatternSyntaxException
    extends Exception {
        private static final long serialVersionUID = 6266881831979001480L;
        private final PatternSyntaxException pse;

        public CheckedPatternSyntaxException(PatternSyntaxException pse) {
            this.pse = pse;
        }

        public CheckedPatternSyntaxException(String desc, String regex, @GTENegativeOne int index) {
            this(new PatternSyntaxException(desc, regex, index));
        }

        public String getDescription() {
            return this.pse.getDescription();
        }

        public int getIndex() {
            return this.pse.getIndex();
        }

        @Override
        @Pure
        public String getMessage(@GuardSatisfied CheckedPatternSyntaxException this) {
            return this.pse.getMessage();
        }

        public String getPattern() {
            return this.pse.getPattern();
        }
    }
}

