/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.validation.SubValidator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class BundleZipValidator
extends SubValidator {
    @Override
    public void validateBundleZipEntry(ZipFile bundleFile, ZipEntry zipEntry) {
        if (zipEntry.isDirectory()) {
            throw InvalidBundleException.builder().withUserMessage("The bundle zip file contains directory zip entry '%s' which is not allowed.", zipEntry.getName()).build();
        }
        if (zipEntry.getName().startsWith("/")) {
            throw InvalidBundleException.builder().withUserMessage("The bundle zip file contains a zip entry starting with /, which is not allowed: '%s'.", zipEntry.getName()).build();
        }
    }
}

