/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.AbiName;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.regex.Pattern;

public class BundleFilesValidator
extends SubValidator {
    private static final Pattern CLASSES_DEX_PATTERN = Pattern.compile("classes[0-9]*\\.dex");
    private static final ImmutableSet<ZipPath> RESERVED_ROOT_APK_ENTRIES = ImmutableSet.of(BundleModule.LIB_DIRECTORY, BundleModule.RESOURCES_DIRECTORY, ZipPath.create("AndroidManifest.xml"), ZipPath.create("resources.arsc"), ZipPath.create("AndroidManifest.xml"), BundleModule.SpecialModuleEntry.RESOURCE_TABLE.getPath(), new ZipPath[0]);

    @Override
    public void validateModuleFile(ZipPath file) {
        String fileName = file.getFileName().toString();
        if (!file.startsWith(BundleModule.ASSETS_DIRECTORY)) {
            if (file.startsWith(BundleModule.DEX_DIRECTORY)) {
                if (!fileName.endsWith(".dex")) {
                    throw InvalidBundleException.builder().withUserMessage("Files under %s/ must have %s extension, found '%s'.", BundleModule.DEX_DIRECTORY, ".dex", file).build();
                }
                if (!CLASSES_DEX_PATTERN.matcher(fileName).matches()) {
                    throw InvalidBundleException.builder().withUserMessage("Files under %s/ must match the 'classes[0-9]*.dex' pattern, found '%s'.", BundleModule.DEX_DIRECTORY, file).build();
                }
                if (file.getNameCount() != 2) {
                    throw InvalidBundleException.builder().withUserMessage("The %s/ directory cannot contain directories, found '%s'.", BundleModule.DEX_DIRECTORY, file).build();
                }
            } else if (file.startsWith(BundleModule.LIB_DIRECTORY)) {
                if (file.getNameCount() != 3) {
                    throw InvalidBundleException.builder().withUserMessage("Native library files need to have paths in form '%s/<single-directory>/<file>.so' but found '%s'.", BundleModule.LIB_DIRECTORY, file).build();
                }
                if (!fileName.endsWith(".so") && !fileName.equals("wrap.sh")) {
                    throw InvalidBundleException.builder().withUserMessage("Files under %s/ must have %s extension, found '%s'.", BundleModule.LIB_DIRECTORY, ".so", file).build();
                }
                String subDirName = file.getName(1).toString();
                if (!AbiName.fromLibSubDirName(subDirName).isPresent()) {
                    throw InvalidBundleException.builder().withUserMessage("Unrecognized native architecture for directory '%s'.", file.subpath(0, 2)).build();
                }
            } else if (file.startsWith(BundleModule.MANIFEST_DIRECTORY)) {
                if (!fileName.equals("AndroidManifest.xml")) {
                    throw InvalidBundleException.builder().withUserMessage("Only '%s' is accepted under directory '%s/' but found file '%s'.", "AndroidManifest.xml", BundleModule.MANIFEST_DIRECTORY, file).build();
                }
            } else if (!file.startsWith(BundleModule.RESOURCES_DIRECTORY)) {
                if (file.startsWith(BundleModule.ROOT_DIRECTORY)) {
                    ZipPath nameUnderRoot = file.getName(1);
                    if (BundleFilesValidator.isReservedRootApkEntry(nameUnderRoot)) {
                        throw InvalidBundleException.builder().withUserMessage("File '%s' uses reserved file or directory name '%s'.", file, nameUnderRoot).build();
                    }
                } else if (file.startsWith(BundleModule.APEX_DIRECTORY)) {
                    if (file.getNameCount() != 2) {
                        throw InvalidBundleException.builder().withUserMessage("APEX image files need to have paths in form '%s/<file>.img' but found '%s'.", BundleModule.APEX_DIRECTORY, file).build();
                    }
                    if (!fileName.endsWith(".img") && !fileName.endsWith(".build_info.pb")) {
                        throw InvalidBundleException.builder().withUserMessage("Files under %s/ must have %s extension, found '%s'.", BundleModule.APEX_DIRECTORY, ".img", file).build();
                    }
                    BundleFilesValidator.validateMultiAbiFileName(file);
                } else {
                    throw InvalidBundleException.builder().withUserMessage("Module files can be only in pre-defined directories, but found '%s'.", file).build();
                }
            }
        }
    }

    private static boolean isReservedRootApkEntry(ZipPath name) {
        return RESERVED_ROOT_APK_ENTRIES.contains(name) || CLASSES_DEX_PATTERN.matcher(name.toString()).matches();
    }

    private static void validateMultiAbiFileName(ZipPath file) {
        if (!file.toString().endsWith(".img")) {
            return;
        }
        ImmutableList<String> tokens = ImmutableList.copyOf(BundleModule.ABI_SPLITTER.splitToList(file.getFileName().toString()));
        int nAbis = tokens.size() - 1;
        ImmutableList abis = tokens.stream().limit(nAbis).map(AbiName::fromPlatformName).collect(ImmutableList.toImmutableList());
        if (!abis.stream().allMatch(Optional::isPresent)) {
            throw InvalidBundleException.builder().withUserMessage("Unrecognized native architecture for file '%s'.", file).build();
        }
        ImmutableSet uniqueAbis = abis.stream().map(Optional::get).collect(ImmutableSet.toImmutableSet());
        if (uniqueAbis.size() != nAbis) {
            throw InvalidBundleException.builder().withUserMessage("Repeating architectures in APEX system image file '%s'.", file).build();
        }
    }
}

