/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.internal.jdwp;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AdbHelper;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.DdmPreferences;
import com.android.ddmlib.JdwpHandshake;
import com.android.ddmlib.Log;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.internal.jdwp.JdwpClientManagerId;
import com.android.ddmlib.internal.jdwp.JdwpConnectionReader;
import com.android.ddmlib.internal.jdwp.JdwpLoggingUtils;
import com.android.ddmlib.internal.jdwp.JdwpProxyClient;
import com.android.ddmlib.internal.jdwp.JdwpSocketHandler;
import com.android.ddmlib.internal.jdwp.chunkhandler.JdwpPacket;
import com.android.ddmlib.internal.jdwp.interceptor.ClientInitializationInterceptor;
import com.android.ddmlib.internal.jdwp.interceptor.DebuggerInterceptor;
import com.android.ddmlib.internal.jdwp.interceptor.Interceptor;
import com.android.ddmlib.internal.jdwp.interceptor.NoReplyPacketInterceptor;
import com.google.common.annotations.VisibleForTesting;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class JdwpClientManager
implements JdwpSocketHandler {
    private SocketChannel mAdbSocket;
    private final Set<JdwpProxyClient> mClients = new HashSet<JdwpProxyClient>();
    private final List<Interceptor> mInterceptors = new ArrayList<Interceptor>();
    private final List<ShutdownListener> mShutdownListeners = new ArrayList<ShutdownListener>();
    private JdwpConnectionReader mReader;
    private boolean isHandshakeComplete = false;

    public JdwpClientManager(JdwpClientManagerId id2, Selector selector) throws TimeoutException, AdbCommandRejectedException, IOException {
        this(AdbHelper.createPassThroughConnection(AndroidDebugBridge.getSocketAddress(), id2.deviceSerial, id2.pid));
        this.mAdbSocket.configureBlocking(false);
        this.mAdbSocket.register(selector, 1, this);
    }

    @VisibleForTesting
    JdwpClientManager(SocketChannel socket) throws TimeoutException, AdbCommandRejectedException, IOException {
        this.mReader = new JdwpConnectionReader(socket, 1024);
        this.mAdbSocket = socket;
        this.mInterceptors.add(new NoReplyPacketInterceptor());
        this.mInterceptors.add(new ClientInitializationInterceptor());
        this.mInterceptors.add(new DebuggerInterceptor());
        this.sendHandshake();
    }

    private void sendHandshake() throws IOException, TimeoutException {
        ByteBuffer handshake = ByteBuffer.allocate(JdwpHandshake.HANDSHAKE_LEN);
        JdwpHandshake.putHandshake(handshake);
        this.writeRaw(handshake);
    }

    void addListener(JdwpProxyClient client) {
        this.mClients.add(client);
    }

    void removeListener(JdwpProxyClient client) {
        this.mClients.remove(client);
    }

    void addShutdownListener(ShutdownListener listener) {
        this.mShutdownListeners.add(listener);
    }

    @VisibleForTesting
    void addInterceptor(Interceptor interceptor) {
        this.mInterceptors.add(interceptor);
    }

    @Override
    public void shutdown() throws IOException {
        for (ShutdownListener listener : this.mShutdownListeners) {
            listener.shutdown();
        }
        this.mShutdownListeners.clear();
        while (!this.mClients.isEmpty()) {
            JdwpProxyClient client = this.mClients.iterator().next();
            client.shutdown();
            if (!this.mClients.contains(client)) continue;
            this.mClients.remove(client);
        }
        if (this.mAdbSocket != null) {
            this.mAdbSocket.close();
            this.mAdbSocket = null;
        }
    }

    @Override
    public void read() throws IOException, TimeoutException {
        JdwpPacket packet;
        if (this.mAdbSocket == null) {
            return;
        }
        int length = this.mReader.read();
        if (length == -1) {
            this.shutdown();
            throw new EOFException("Client disconnected");
        }
        while (!this.isHandshakeComplete) {
            if (this.mReader.isHandshake()) {
                this.mReader.consumeData(JdwpHandshake.HANDSHAKE_LEN);
                this.isHandshakeComplete = true;
                break;
            }
            if (!this.mReader.isAPNMPacket()) {
                Log.e("DDMLIB", "An unexpected packet was received before the handshake.");
                return;
            }
            this.mReader.consumePacket();
        }
        while ((packet = this.mReader.readPacket()) != null) {
            ByteBuffer sendBuffer = ByteBuffer.allocate(packet.getLength());
            packet.copy(sendBuffer);
            for (JdwpProxyClient client : this.mClients) {
                if (this.filterToClient(client, packet)) continue;
                client.write(sendBuffer.array(), sendBuffer.position());
            }
            packet.consume();
        }
    }

    void write(JdwpProxyClient from, JdwpPacket packet) throws IOException, TimeoutException {
        if (this.mAdbSocket == null) {
            return;
        }
        if (!this.filterToDevice(from, packet)) {
            ByteBuffer sendBuffer = ByteBuffer.allocate(packet.getLength());
            packet.copy(sendBuffer);
            this.writeRaw(sendBuffer);
        }
    }

    @VisibleForTesting
    void writeRaw(ByteBuffer sendBuffer) throws IOException, TimeoutException {
        JdwpLoggingUtils.log("DEVICE", "WRITE", sendBuffer.array(), sendBuffer.position());
        AdbHelper.write(this.mAdbSocket, sendBuffer.array(), sendBuffer.position(), DdmPreferences.getTimeOut());
    }

    private boolean filterToDevice(JdwpProxyClient client, JdwpPacket packet) throws IOException, TimeoutException {
        boolean filter = false;
        for (Interceptor interceptor : this.mInterceptors) {
            filter |= interceptor.filterToDevice(client, packet);
        }
        return filter;
    }

    private boolean filterToClient(JdwpProxyClient client, JdwpPacket packet) throws IOException, TimeoutException {
        boolean filter = false;
        for (Interceptor interceptor : this.mInterceptors) {
            filter |= interceptor.filterToClient(client, packet);
        }
        return filter;
    }

    static interface ShutdownListener {
        public void shutdown();
    }
}

