/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.shards;

import com.android.bundle.Devices;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.device.ApkMatcher;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import com.android.tools.build.bundletool.model.utils.TargetingProtoUtils;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.inject.Inject;

public class Sharder {
    private final Optional<Devices.DeviceSpec> deviceSpec;

    @Inject
    public Sharder(Optional<Devices.DeviceSpec> deviceSpec) {
        this.deviceSpec = deviceSpec;
    }

    public ImmutableList<ImmutableList<ModuleSplit>> groupSplitsToShards(ImmutableList<ModuleSplit> splits) {
        ImmutableSet<ModuleSplit> abiSplits = this.subsetWithTargeting(splits, Targeting.ApkTargeting::hasAbiTargeting);
        ImmutableSet<ModuleSplit> densitySplits = this.subsetWithTargeting(splits, Targeting.ApkTargeting::hasScreenDensityTargeting);
        ImmutableSet<ModuleSplit> languageSplits = Sharder.getLanguageSplits(splits);
        ImmutableSet<ModuleSplit> masterSplits = Sharder.getMasterSplits(splits);
        Preconditions.checkState(Collections.disjoint(Sets.newHashSet(abiSplits), Sets.newHashSet(densitySplits)), "No split is expected to have both ABI and screen density targeting.");
        Preconditions.checkState(Sharder.sameTargetedUniverse(densitySplits, split -> TargetingProtoUtils.densityUniverse(split.getApkTargeting())), "Density splits are expected to cover the same densities.");
        if (!Sharder.sameTargetedUniverse(abiSplits, split -> TargetingProtoUtils.abiUniverse(split.getApkTargeting()))) {
            throw CommandExecutionException.builder().withInternalMessage("Modules for standalone APKs must cover the same ABIs when optimizing for ABI.").build();
        }
        Collection abiSplitsSubsets = Sharder.nonEmpty(Sharder.partitionByTargeting(abiSplits));
        Collection densitySplitsSubsets = Sharder.nonEmpty(Sharder.partitionByTargeting(densitySplits));
        ImmutableList.Builder shards = ImmutableList.builder();
        for (Collection abiSplitsSubset : abiSplitsSubsets) {
            for (Collection densitySplitsSubset : densitySplitsSubsets) {
                shards.add(((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(masterSplits)).addAll(languageSplits)).addAll((Iterable)abiSplitsSubset)).addAll((Iterable)densitySplitsSubset)).build());
            }
        }
        return shards.build();
    }

    private ImmutableSet<ModuleSplit> subsetWithTargeting(ImmutableList<ModuleSplit> splits, Predicate<Targeting.ApkTargeting> predicate) {
        return splits.stream().filter(split -> predicate.test(split.getApkTargeting())).filter(split -> this.deviceSpec.map(spec -> Sharder.splitMatchesDeviceSpec(split, spec)).orElse(true)).collect(ImmutableSet.toImmutableSet());
    }

    private static ImmutableSet<ModuleSplit> getMasterSplits(ImmutableList<ModuleSplit> splits) {
        ImmutableSet<ModuleSplit> masterSplits = splits.stream().filter(ModuleSplit::isMasterSplit).collect(ImmutableSet.toImmutableSet());
        Preconditions.checkState(masterSplits.size() >= 1, "Expecting at least one master split, got %s.", masterSplits.size());
        Preconditions.checkState(masterSplits.stream().allMatch(split -> split.getApkTargeting().toBuilder().clearTextureCompressionFormatTargeting().clearDeviceTierTargeting().clearCountrySetTargeting().build().equals(Targeting.ApkTargeting.getDefaultInstance())), "Master splits can not have any targeting other than Texture Compression Format, Device Tier and Country Set.");
        return masterSplits;
    }

    private static ImmutableSet<ModuleSplit> getLanguageSplits(ImmutableList<ModuleSplit> splits) {
        return splits.stream().filter(split -> split.getApkTargeting().hasLanguageTargeting()).collect(ImmutableSet.toImmutableSet());
    }

    private static ImmutableCollection<Collection<ModuleSplit>> partitionByTargeting(Collection<ModuleSplit> splits) {
        return ((ImmutableMap)Multimaps.index(splits, ModuleSplit::getApkTargeting).asMap()).values();
    }

    private static <T> Collection<Collection<T>> nonEmpty(Collection<Collection<T>> x11) {
        return x11.isEmpty() ? ImmutableList.of(ImmutableList.of()) : x11;
    }

    private static boolean sameTargetedUniverse(Set<ModuleSplit> splits, Function<ModuleSplit, Collection<?>> getUniverseFn) {
        long distinctNonEmptyUniverseCount = splits.stream().map(getUniverseFn::apply).filter(Predicates.not(Collection::isEmpty)).distinct().count();
        return distinctNonEmptyUniverseCount <= 1L;
    }

    static boolean splitMatchesDeviceSpec(ModuleSplit moduleSplit, Devices.DeviceSpec deviceSpec) {
        return new ApkMatcher(deviceSpec).matchesModuleSplitByTargeting(moduleSplit);
    }
}

