/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.util;

import com.android.apksig.util.RunnablesProvider;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Phaser;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public interface RunnablesExecutor {
    public static final RunnablesExecutor SINGLE_THREADED = p11 -> p11.createRunnable().run();
    public static final RunnablesExecutor MULTI_THREADED = new RunnablesExecutor(){
        private final int PARALLELISM = Math.min(32, Runtime.getRuntime().availableProcessors());
        private final int QUEUE_SIZE = 4;

        @Override
        public void execute(RunnablesProvider provider) {
            ThreadPoolExecutor mExecutor = new ThreadPoolExecutor(this.PARALLELISM, this.PARALLELISM, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(4), new ThreadPoolExecutor.CallerRunsPolicy());
            Phaser tasks = new Phaser(1);
            for (int i11 = 0; i11 < this.PARALLELISM; ++i11) {
                Runnable task = () -> {
                    Runnable r11 = provider.createRunnable();
                    r11.run();
                    tasks.arriveAndDeregister();
                };
                tasks.register();
                mExecutor.execute(task);
            }
            tasks.arriveAndAwaitAdvance();
            mExecutor.shutdownNow();
        }
    };

    public void execute(RunnablesProvider var1);
}

