﻿
# game/tutorial_quickstart.rpy:28
translate japanese tutorial_create_27048c11:

    # e "When you're ready to use Ren'Py to create your visual novel, the first step is to create a new project."
    e "ビジュアルノベル作成のためにRen'Pyを使用する準備ができたら、最初に新しいプロジェクトを作成します。"

# game/tutorial_quickstart.rpy:30
translate japanese tutorial_create_bae6289c:

    # e "You can create a new project by clicking 'Create New Project' on the front screen of the launcher."
    e "ランチャーの'新規プロジェクトの作成'をクリックして新しいプロジェクトを作成できます。"

# game/tutorial_quickstart.rpy:32
translate japanese tutorial_create_45915fcb:

    # e "If this is your first time using Ren'Py, it'll ask you for the place you want to keep your projects. The best place is always somewhere that's frequently backed up."
    e "初めてRen'Pyを使うなら、プロジェクトを保存する場所を尋ねます。頻繁にバックアップされる場所がよいです。"

# game/tutorial_quickstart.rpy:36
translate japanese tutorial_create_55e30cb5:

    # e "After that, Ren'Py will ask for a name for your project. You'll have to stick to English letters and numbers, as zip files can't handle anything more than that."
    e "そうしたら、Ren'Pyはプロジェクトの名前を尋ねるので半角英数を入力してください。zipファイルは他の文字を扱えません。"

# game/tutorial_quickstart.rpy:40
translate japanese tutorial_create_dea3e5c2:

    # e "The next thing Ren'Py will ask for is the resolution the visual novel will run at. This controls how large or small you'll have to make your game's artwork."
    e "次に、Ren'Pyはビジュアルノベルの解像度を尋ねます。これはゲームの画像サイズをいくつで作るかを決めます。"

# game/tutorial_quickstart.rpy:44
translate japanese tutorial_create_3289ea75:

    # e "Finally, Ren'Py will ask you to select a color scheme. You can change this after the game has been created, so just pick a color that's pleasing."
    e "最後に、Ren'Pyはカラースキームを尋ねます。これはゲーム作成後も変更できるので、たんに気にいったものを選んでください。"

# game/tutorial_quickstart.rpy:48
translate japanese tutorial_create_6b9e3b96:

    # e "Once that's done, Ren'Py will work for a bit and return you to the main menu with the new project selected. Now, when you click Launch, Ren'Py will start your new game."
    e "いったんこれらが済めば、Ren'Pyは少し作業をして、新しいプロジェクトを選択した状態でメインメニューに戻ります。これで、プロジェクトの起動をクリックすればRen'Pyはあなたの新しいゲームを実行します。"

# game/tutorial_quickstart.rpy:50
translate japanese tutorial_create_bdf94f9b:

    # e "To get back here, you can choose 'Tutorial' to switch to this tutorial game."
    e "ここに戻るには'Tutorial'を選択してこのチュートリアルゲームに切り替えます。"

# game/tutorial_quickstart.rpy:52
translate japanese tutorial_create_22f516df:

    # e "You'll also need to edit the games script to make changes. To do that, click 'script.rpy' on the front page of the launcher."
    e "ゲーム作成のために、スクリプトも変更する必要があります。そのためには、ランチャーのフロントページの'script.rpy'をクリックして下さい。"

# game/tutorial_quickstart.rpy:54
translate japanese tutorial_create_9151025b:

    # e "If it's your first time doing so, Ren'Py will ask you to select a text editor. Atom might be a safe choice, but read the descriptions to be sure."
    e "初めてクリックしたなら、Ren'Pyはテキストエディターの選択を促します。Atomが無難でしょうが、説明を読んで選択してください。"

# game/tutorial_quickstart.rpy:56
translate japanese tutorial_create_bfbd6220:

    # e "After the text editor is downloaded, the script will open up and you can start to change what characters are saying."
    e "テキストエディターがダウンロードされると、スクリプトが開かれ、キャラクターが話す内容を変更できます。"

# game/tutorial_quickstart.rpy:69
translate japanese tutorial_dialogue_112ff505:

    # e "Probably the most common thing a creator does with Ren'Py is to write dialogue for the player to read."
    e "Ren'Pyで製作者がもっとも行うことは多分プレイヤーが読む台詞を記述することでしょう"

# game/tutorial_quickstart.rpy:71
translate japanese tutorial_dialogue_be2be31a:

    # e "But before I can show you how to write dialogue, let me show you how we present script examples."
    e "どのように台詞を記述するかの前に、どのようにスクリプトの例を表示するかを説明します。"

# game/tutorial_quickstart.rpy:74
translate japanese tutorial_dialogue_7b6be28e:

    # "Eileen" "Examples will show up in a window like the one above. You'll need to click outside of the example window in order to advance the tutorial."
    "Eileen" "例は上記のようにウィンドウに表示されます。チュートリアルを進めるにはサンプルウィンドウ以外をクリックしてください。"

# game/tutorial_quickstart.rpy:76
translate japanese tutorial_dialogue_5269d005:

    # "Eileen" "When an example is bigger than the screen, you can scroll around in it using the mouse wheel or by simply dragging the mouse."
    "Eileen" "例がスクリーンよりも大きい時は、マウスホイールを使うか、単純にマウスでドラッグすることにより周りにスクロールできます。"

# game/tutorial_quickstart.rpy:78
translate japanese tutorial_dialogue_241c0c74:

    # "Eileen" "Script might seem scary at first, but if you look you'll see it's easy to match it up to what I'm saying."
    "Eileen" "スクリプトは初めのうちは奇妙に見えるかもしれませんが、説明とサンプルを見くらべれば分かるようになるでしょう。"

# game/tutorial_quickstart.rpy:82
translate japanese tutorial_dialogue_f0d66410:

    # e "Let's see the simplest possible Ren'Py game."
    e "では、最も簡単で使えるRen'Pyゲームを見てみましょう。"

# game/tutorial_quickstart.rpy:89
translate japanese tutorial_dialogue_3e6b0068:

    # "Wow, it's really really dark in here."
    "わっ！ここって、とても暗いわね。"

# game/tutorial_quickstart.rpy:91
translate japanese tutorial_dialogue_5072a404:

    # "Lucy" "Better watch out. You don't want to be eaten by a Grue."
    "Lucy" "気をつけて。モンスターの餌食にはなりたくないでしょ。"

# game/tutorial_quickstart.rpy:99
translate japanese tutorial_dialogue_d39d1b2b:

    # e "I'll show you the script of that example."
    e "この例のスクリプトを示します。"

# game/tutorial_quickstart.rpy:101
translate japanese tutorial_dialogue_f51ecf1f:

    # e "This script demonstrates two kinds of Ren'Py statements, labels and say statements."
    e "このスクリプトはRen'Pyの重要なステートメントを2つ示しており、それぞれラベル及び発言ステートメントです。"

# game/tutorial_quickstart.rpy:103
translate japanese tutorial_dialogue_bc7ec147:

    # e "The first line is a label statement. The label statement is used to give a name to a place in the program."
    e "1行目はラベルステートメントです。ラベルステートメントは、プログラムのある場所に名前を付けるために使用されます。"

# game/tutorial_quickstart.rpy:105
translate japanese tutorial_dialogue_b20db833:

    # e "In this case, we're naming a place \"start\". The start label is special, as it marks the place a game begins running."
    e "この場合は、\"start\" という名前を付けています。startラベルは特殊で、ゲームはこのマークがされた場所から始まります。"

# game/tutorial_quickstart.rpy:107
translate japanese tutorial_dialogue_b0afbe96:

    # e "The next line is a simple say statement. It consists of a string beginning with a double-quote, and ending at the next double-quote."
    e "次の行は単純な発言ステートメントです。文字列の始まりにダブルクォーテーション、終わりに次のダブルクォーテーションという形で構成されています。"

# game/tutorial_quickstart.rpy:109
translate japanese tutorial_dialogue_628c9e4c:

    # e "Special characters in strings can be escaped with a backslash. To include \" in a string, we have to write \\\"."
    e "文字列中の特殊文字はバックスラッシュでエスケープできます。文字列中に \" を含む場合は \\\" と書く必要があります。"

# game/tutorial_quickstart.rpy:116
translate japanese tutorial_dialogue_3e6b0068_1:

    # "Wow, it's really really dark in here."
    "わっ！ここって、とても暗いわね。"

# game/tutorial_quickstart.rpy:125
translate japanese tutorial_dialogue_d7f0b5b7:

    # e "When Ren'Py sees a single string on a line by itself, it uses the narrator to say that string. So a single string can be used to express a character's thoughts."
    e "Ren'Pyが1行に単一の文字列を見かけたときは、ナレーターがその文字列を発言したことになります。ですので、単一の文字列はキャラクターの考えていることを書くのに使えます。"

# game/tutorial_quickstart.rpy:131
translate japanese tutorial_dialogue_5072a404_1:

    # "Lucy" "Better watch out. You don't want to be eaten by a Grue."
    "Lucy" "気をつけて。モンスターの餌食にはなりたくないでしょ。"

# game/tutorial_quickstart.rpy:139
translate japanese tutorial_dialogue_9dd2d543:

    # e "When we have two strings separated by a space, the first is used as the character's name, and the second is what the character is saying."
    e "2つの文字列が空白によって分けられているときは、1つ目はキャラクターの名前として使われ、2つ目はキャラクターの発言となります。"

# game/tutorial_quickstart.rpy:141
translate japanese tutorial_dialogue_64ffe685:

    # e "This two-argument form of the say statement is used for dialogue, where a character is speaking out loud."
    e "2つの引数からなる発言ステートメントは、キャラクターが声に出して話している場面で使われます。"

# game/tutorial_quickstart.rpy:143
translate japanese tutorial_dialogue_97a33275:

    # e "If you'd like, you can run this game yourself by erasing everything in your project's script.rpy file, and replacing it with the code in the box above."
    e "試しに、プロジェクトの script.rpy ファイルを空にし、上記ボックスのコードに置き換えて実行してみて下さい。"

# game/tutorial_quickstart.rpy:145
translate japanese tutorial_dialogue_c5e70d7e:

    # e "Be sure to preserve the spacing before lines. That's known as indentation, and it's used to help Ren'Py group lines of script into blocks."
    e "行の前に空白があることを確認して下さい。これはインデントと言われ、Ren'Pyがスクリプトをブロックに分割するために使われます。"

# game/tutorial_quickstart.rpy:149
translate japanese tutorial_dialogue_90719f73:

    # e "Using a string for a character's name is inconvenient, for two reasons."
    e "キャラクター名に文字列を使うことは、次の2点の理由から不便と言えます。"

# game/tutorial_quickstart.rpy:151
translate japanese tutorial_dialogue_910f286a:

    # e "The first is that it's a bit verbose. While typing \"Lucy\" isn't so bad, imagine if you had to type \"Eileen Richardson\" thousands of times."
    e "まず、少し冗長だからです。\"ルーシー\" と入力する時は問題ないですが、\"エイリーン・リチャードソン\" を数千回入力しなければならない場合はどうでしょうか。"

# game/tutorial_quickstart.rpy:153
translate japanese tutorial_dialogue_9c9d59c2:

    # e "The second is that it doesn't leave any place to put styling, which can change the look of a character."
    e "2つ目は、キャラクターによって変えられるスタイルを入力する場所がないからです。"

# game/tutorial_quickstart.rpy:155
translate japanese tutorial_dialogue_2a2d1e51:

    # e "To solve these problems, Ren'Py lets you define Characters."
    e "これらの問題を解決するために、Ren'Pyではキャラクターを定義できます。"

# game/tutorial_quickstart.rpy:159
translate japanese tutorial_dialogue_16e8c5fd:

    # e "Here's an example Character definition. It begins with the word \"define\". That tells Ren'Py that we are defining something."
    e "キャラクターの定義例を示します。これは \"define\" という語から始まっています。これによってRen'Pyに私たちが何かを定義していることを知らせます。"

# game/tutorial_quickstart.rpy:161
translate japanese tutorial_dialogue_34fe5aa0:

    # e "Define is followed by a short name for the character, like \"l\". We'll be able to use that short name when writing dialogue."
    e "defineは \"l\" のようなキャラクターの短縮名に続いています。私たちは会話を書くときに、この短縮名を使えます。"

# game/tutorial_quickstart.rpy:163
translate japanese tutorial_dialogue_67f90201:

    # e "This is followed by an equals sign, and the thing that we're defining. In this case, it's a Character."
    e "続いて等号があります。そして何を定義するかです。今回の場合は Character です。"

# game/tutorial_quickstart.rpy:165
translate japanese tutorial_dialogue_4e454a89:

    # e "On the first line, the character's name is given to be \"Lucy\", and her name will be drawn a reddish color."
    e "最初の部分で、キャラクター名 \"ルーシー\" が与えられ、次の部分により彼女の名前は赤っぽい色で描画されます。"

# game/tutorial_quickstart.rpy:167
translate japanese tutorial_dialogue_db11f026:

    # e "These short names are case-sensitive. Capital L is a different name from lower-case l, so you'll need to be careful about that."
    e "これらの短縮名は大文字と小文字が区別されます。大文字の L は小文字の l と異なる名前となるので注意が必要です。"

# game/tutorial_quickstart.rpy:171
translate japanese tutorial_dialogue_1d161320:

    # e "Now that we have a character defined, we can use it to say dialogue."
    e "これにより、定義されたキャラクターを用いて対話できます。"

# game/tutorial_quickstart.rpy:178
translate japanese tutorial_dialogue_3710169c:

    # l "Why are you trying to put words into my mouth? And who are you calling \"it\"?"
    l "そんなこと言ってないわよ。あと、「ここ」ってどこ？"

# game/tutorial_quickstart.rpy:180
translate japanese tutorial_dialogue_6d463776:

    # l "What's more, what are you going to do about the Grue problem? Are you just going to leave me here?"
    l "もっと重要なことだけど、モンスターの問題に対して何かするつもり？私だけ置き去りにするの？"

# game/tutorial_quickstart.rpy:188
translate japanese tutorial_dialogue_023bcd31:

    # e "Here's the full game, including the two new lines of dialogue, both of which use the Character we defined to say dialogue."
    e "ゲーム全体を示します。会話を新しく2行追加しましたが、とちらもキャラクターを定義して使っています。"

# game/tutorial_quickstart.rpy:190
translate japanese tutorial_dialogue_48bb9547:

    # e "The one-argument form of the say statement is unchanged, but in the two-argument form, instead of the first string we can use a short name."
    e "1つの引数からなる発言ステートメントは変わっていませんが、2つの引数からなる方では、1つ目の引数で代わりに短縮名を使えます。"

# game/tutorial_quickstart.rpy:192
translate japanese tutorial_dialogue_56a9936f:

    # e "When this say statement is run, Ren'Py will look up the short name, which is really a Python variable. It will then use the associated Character to show the dialogue."
    e "この発言ステートメントが実行されるとRen'Pyは短縮名を探しますが、その実体はPythonの変数です。そして関連するキャラクターを用いて会話を表示します。"

# game/tutorial_quickstart.rpy:194
translate japanese tutorial_dialogue_d5984a21:

    # e "The Character object controls who is speaking, the color of their name, and many other properties of the dialogue."
    e "キャラクターオブジェクトは、誰が話しているか、名前の色、その他会話に関連するたくさんのことを制御します。"

# game/tutorial_quickstart.rpy:198
translate japanese tutorial_dialogue_a5bcac8b:

    # e "Since the bulk of a visual novel is dialogue, we've tried to make it as easy to write as possible."
    e "ビジュアルノベルの大半は会話なので、私たちはできるだけそれを簡潔に記述できるように試みました。"

# game/tutorial_quickstart.rpy:200
translate japanese tutorial_dialogue_6b9a42d0:

    # e "Hopefully, by allowing the use of short names for characters, we've succeeded."
    e "うまいことに、キャラクター名に短縮名を使えるようにすることで成功しました。"

# game/tutorial_quickstart.rpy:206
translate japanese tutorial_images_e09ac970:

    # e "A visual novel isn't much without images. So let's add some images to our little game."
    e "画像のないビジュアルノベルはあまりありません。では、ちょっとしたゲームにいくつか画像を追加してみましょう。"

# game/tutorial_quickstart.rpy:208
translate japanese tutorial_images_40140793:

    # e "Before we can show images, we must first choose image names, then place the image files into the images directory."
    e "画像を表示するには、まず画像名を選択してimageディレクトリに画像ファイルを配置する必要があります。"

# game/tutorial_quickstart.rpy:210
translate japanese tutorial_images_d73388f8:

    # e "An image name is something like 'bg cave' or 'lucy happy', with one or more parts separated by spaces."
    e "画像名は'bg cave'や'lucy happy'のようなもので、スペース区切りの一つ以上のパーツを持ちます。"

# game/tutorial_quickstart.rpy:212
translate japanese tutorial_images_2d5596d4:

    # e "Each part should start with a lower-case letter, and then contain lower-case letters, numbers, and underscores."
    e "各パーツは小文字ではじまり、小文字、数字、アンダースコアを含みます。"

# game/tutorial_quickstart.rpy:214
translate japanese tutorial_images_e02c0c82:

    # e "The first part of an image is called the tag. For 'bg cave' the tag is 'bg', while for 'lucy happy' the tag is 'lucy'."
    e "画像の最初のパーツはタグと呼ばれ、'bg cave'ならタグは'bg',  'lucy happy'ならタグは'lucy'です。"

# game/tutorial_quickstart.rpy:216
translate japanese tutorial_images_d5eafcf2:

    # e "You can open the images directory by clicking the appropriate button in the Ren'Py launcher."
    e "ランチャーのimagesボタンをクリックしてimagesディレクトリを開けます。"

# game/tutorial_quickstart.rpy:218
translate japanese tutorial_images_e4b12fb6:

    # e "The files in the images directory should have the same name as the image, followed by an extension like .jpg, .png, or .webp."
    e "imagesディレクトリのファイルは画像と同じ名前を持ち、.jpgや.png, webpのような拡張子が続きます。"

# game/tutorial_quickstart.rpy:220
translate japanese tutorial_images_a3bd89b2:

    # e "Our example uses 'bg cave.jpg', 'lucy happy.png', and 'lucy mad.png'."
    e "例では'bg cave.jpg',  'lucy happy.png',  'lucy mad.png'を使用しています。"

# game/tutorial_quickstart.rpy:224
translate japanese tutorial_images_76b954de:

    # e "Let's see what those look like in the game."
    e "ゲーム内でどのように表示されるか見てみましょう。"

# game/tutorial_quickstart.rpy:230
translate japanese tutorial_images_f04e72ea:

    # l "Now that the lights are on, we don't have to worry about Grues anymore."
    l "ライトがついたわ。もうモンスターを心配する必要はないわ。"

# game/tutorial_quickstart.rpy:234
translate japanese tutorial_images_d77ffa1c:

    # l "But what's the deal with me being in a cave? Eileen gets to be out in the sun, and I'm stuck here!"
    l "でも、どうして洞窟に居ないといけないのよ。エイリーンは太陽の下にいるのに、もうお手上げよ！"

# game/tutorial_quickstart.rpy:242
translate japanese tutorial_images_6c0c938b:

    # e "Here's the script for that scene. Notice how it includes two new statements, the scene and show statement."
    e "この場面のスクリプトを示します。2つの新しいステートメント scene と show がどのように使われているか注意して見て下さい。"

# game/tutorial_quickstart.rpy:244
translate japanese tutorial_images_1a4660b9:

    # e "The scene statement clears the screen, and then adds a background image."
    e "sceneステートメントは画面を消去してから背景画像を追加します。"

# game/tutorial_quickstart.rpy:246
translate japanese tutorial_images_672c8cb8:

    # e "The show statement adds a background image on top of all the other images on the screen."
    e "showステートメントはその場面の他のすべての画像の一番上に背景画像を追加します。"

# game/tutorial_quickstart.rpy:248
translate japanese tutorial_images_2fc7baee:

    # e "If there was already an image with the same tag, the new image is used to replace the old one."
    e "同じタグの画像が既にあった場合は、古い画像が新しい画像に置き換えられます。"

# game/tutorial_quickstart.rpy:250
translate japanese tutorial_images_802825f2:

    # e "Changes to the list of shown images take place instantly, so in the example, the user won't see the background by itself."
    e "表示されている画像に対する変更は直ちに行われるため、この例ではユーザーが画像の背景を見ることはありません。"

# game/tutorial_quickstart.rpy:252
translate japanese tutorial_images_b246dfdd:

    # e "The second show statement has an at clause, which gives a location on the screen. Common locations are left, right, and center, but you can define many more."
    e "2つ目のshowステートメントでは、画面での位置を指定しています。通常はleft、right、centerで指定しますが、他にもたくさんの指定方法があります。"

# game/tutorial_quickstart.rpy:257
translate japanese tutorial_images_82fceeb8:

    # e "In this example, we show an image named logo base, and we show it at a creator-defined position, rightish."
    e "この例では、logo base という名前の画像をユーザー定義の位置 logopos に表示しています。"

# game/tutorial_quickstart.rpy:259
translate japanese tutorial_images_9defda43:

    # e "We also specify that it should be shown behind another image, in this case eileen. That's me."
    e "さらに、他の画像の背後に表示するように指定しています。この場合は eileen、私です。"

# game/tutorial_quickstart.rpy:264
translate japanese tutorial_images_73d331f7:

    # e "Finally, there's the hide statement, which hides the image with the given tag."
    e "最後にhideステートメントがあります。これは指定されたタグの画像を隠します。"

# game/tutorial_quickstart.rpy:266
translate japanese tutorial_images_f34f62d5:

    # e "Since the show statement replaces an image, and the scene statement clears the scene, it's pretty rare to hide an image."
    e "showステートメントが画像を置き換え、sceneステートメントは場面を消去するので、画像を消去するコマンドはあまり出てきません。"

# game/tutorial_quickstart.rpy:268
translate japanese tutorial_images_e06fa53a:

    # e "The main use is for when a character or prop leaves before the scene is over."
    e "主な用途は、場面が終わる前にキャラクターや小道具を消すときに使います。"

# game/tutorial_quickstart.rpy:282
translate japanese tutorial_simple_positions_b492e793:

    # e "When the standard positions that come with Ren'Py aren't enough for you, you can create your own. Here, I'll show you the easy way to do it."
    e "Ren'Py標準の配置では不満なときは、自分で作成できます。ここでそのための簡単な方法を示します。"

# game/tutorial_quickstart.rpy:291
translate japanese tutorial_simple_positions_04e3bc44:

    # e "The first way to do it is to show an image followed by a colon. Then indented on the next couple of lines are the xalign and yalign transform properties."
    e "最初に、コロンが続く画像を表示します。そしてインデントして次の2行にxalignとyalign transformプロパティーを記述します。"

# game/tutorial_quickstart.rpy:293
translate japanese tutorial_simple_positions_3ecad5f8:

    # e "Each of the transform properties is a name followed by a value. For xalign and yalign, the values are numbers."
    e "各transformプロパティーは名前の後に値が続きます。xalignとyalignでは、値は数値です。"

# game/tutorial_quickstart.rpy:295
translate japanese tutorial_simple_positions_61c1b124:

    # e "The xalign transform property is the important one, as it controls where the image is placed horizontally on the screen."
    e "xalign transformプロパティーは重要な一つで、画像が画面の水平方向のどこに配置されるかを制御します。"

# game/tutorial_quickstart.rpy:305
translate japanese tutorial_simple_positions_67ebea97:

    # e "An xalign of 0.0 is the left side."
    e "xalign 0.0 は左端"

# game/tutorial_quickstart.rpy:315
translate japanese tutorial_simple_positions_bd4f56d8:

    # e "0.5 is the center."
    e "0.5は中央"

# game/tutorial_quickstart.rpy:324
translate japanese tutorial_simple_positions_fb2c48f2:

    # e "And 1.0 is the right. The decimal place is important and has to be there. Just 1 by itself won't work the same."
    e "1.0は右端です。小数点の配置が重要です。ただの1だと同じようには動作しません。"

# game/tutorial_quickstart.rpy:333
translate japanese tutorial_simple_positions_8eebc9a7:

    # e "Of course, you can pick any position in between."
    e "もちろん、その間のどの場所も選べます。"

# game/tutorial_quickstart.rpy:335
translate japanese tutorial_simple_positions_4cd917f6:

    # e "The yalign property is the same way, with 0.0 being the top of the screen and 1.0 being the bottom. Since most sprites stick to the bottom, it's almost always 1.0."
    e "yalignプロパティーも同様で、0.0が画面の上端、1.0が下端です。ほとんどのスプライトは下端に貼り付くので、ほとんどが1.0です。"

# game/tutorial_quickstart.rpy:341
translate japanese tutorial_simple_positions_fbd1a3eb:

    # e "While being able to write positions like this is useful, having to repeatedly do so isn't. So Ren'Py lets you define a transform once, and reuse it."
    e "このように位置を記述できるのは便利ですが、何度も繰り返えさなければいけません。そこでRen'Pyでは一度Transformを定義したらそれを再利用します。"

# game/tutorial_quickstart.rpy:345
translate japanese tutorial_simple_positions_2377e3b3:

    # e "Usually transforms are defined at the top of a file, right after the characters. But it doesn't matter to Ren'Py where you define them."
    e "通常、Transformはファイルの最初、キャラクター定義のすぐ後で定義されますが、どこで定義するかはRen'Pyでは問題になりません。"

# game/tutorial_quickstart.rpy:347
translate japanese tutorial_simple_positions_3ce7e367:

    # e "The transform is given a name, slightleft, and then the xalign and yalign properties."
    e "このTransformには名前 slightleft が指定され、その後にxalignとyalignのプロパティーが続きます。"

# game/tutorial_quickstart.rpy:355
translate japanese tutorial_simple_positions_82d640d9:

    # e "Once a transform has been defined, you can use it in the at clause of the show statement."
    e "一度Transformが定義されると、showステートメントのat節で使用できるようになります。"

# game/tutorial_quickstart.rpy:360
translate japanese tutorial_simple_positions_16b66785:

    # e "Transforms are sticky. If you replace an image without using a transform, Ren'Py will keep the same transforms it had been using."
    e "Transformはねちっこいものです。Transformを使用せずにある画像を置き換えると、Ren'Pyは前の画像が使っていたTransformを維持します。"

# game/tutorial_quickstart.rpy:364
translate japanese tutorial_simple_positions_5d5e0cfd:

    # e "Of course, there's a lot more to transforms than this. If you want to learn more, you can read the sections on Position Properties, Transforms and Animation, and Transform Properties."
    e "もちろん、Transformにはもっと多くがありますが、詳しくは位置プロパティーとTransformとアニメーション、Transformプロパティーの項を参照してください"

# game/tutorial_quickstart.rpy:366
translate japanese tutorial_simple_positions_e65da9bf:

    # e "But for many visual novels, xalign and yalign are the only properties that matter."
    e "しかし多くのビジュアルノベルではxalignとyalignだけで十分でしょう。"

# game/tutorial_quickstart.rpy:381
translate japanese tutorial_transitions_9b8c714c:

    # e "It can be somewhat jarring for the game to jump from place to place."
    e "位置が一気に飛ぶことはゲームを不快にするかもしれません。"

# game/tutorial_quickstart.rpy:388
translate japanese tutorial_transitions_3e290ea8:

    # e "To help take some of edge off a change in scene, Ren'Py supports the use of transitions. Let's try that scene change again, but this time we'll use transitions."
    e "場面が切り替わるときの変化を和らげるために、Ren'Pyではトランジションを使えます。次はトランジションを使って画面を切り替えてみます。"

# game/tutorial_quickstart.rpy:402
translate japanese tutorial_transitions_9c0a86c4:

    # e "That's much smoother. Here's some example code showing how we include transitions in our game."
    e "より滑らかになりました。どのようにすればゲームにトランジションを含められるか、サンプルコードを示します。"

# game/tutorial_quickstart.rpy:404
translate japanese tutorial_transitions_3e490d40:

    # e "It uses the with statement. The with statement causes the scene to transition from the last things shown to the things currently being shown."
    e "これには with ステートメントを用います。withステートメントは前に表示されている場面から現在表示されている場面にトランジションを付けます。"

# game/tutorial_quickstart.rpy:406
translate japanese tutorial_transitions_a43847df:

    # e "It takes a transition as an argument. In this case, we're using the Dissolve transition. This transition takes as an argument the amount of time the dissolve should take."
    e "これはトランジションを引数に取ります。この場合はディゾルブ(Dissolve)を使っています。このトランジションはディゾルブする時間を引数に取ります。"

# game/tutorial_quickstart.rpy:408
translate japanese tutorial_transitions_6fcee414:

    # e "In this case, each transition takes half a second."
    e "この場合のトランジションは0.5秒間続きます。"

# game/tutorial_quickstart.rpy:412
translate japanese tutorial_transitions_033042cc:

    # e "We can define a short name for a transition, using the define statement. Here, we're defining slowdissolve to be a dissolve that takes a whole second."
    e "トランジションにはdefineステートメントを利用した短縮名を使えます。ここに、1秒間ディソルブする slowdissolve を定義しています。"

# game/tutorial_quickstart.rpy:427
translate japanese tutorial_transitions_0ba82f00:

    # e "Once a transition has been given a short name, we can use it in our game."
    e "トランジションの短縮名を一度決めると、ゲーム中で使うことができます。"

# game/tutorial_quickstart.rpy:431
translate japanese tutorial_transitions_51ff9600:

    # e "Ren'Py defines some transitions for you, like dissolve, fade, and move. For more complex or customized transitions, you'll have to define your own."
    e "Ren'Pyはディゾルブ、フェード、移動といったいくつかのトランジションを定義しています。もっと複雑にする場合や、カスタマイズする場合は、自身で定義する必要があります。"

# game/tutorial_quickstart.rpy:433
translate japanese tutorial_transitions_1528f73f:

    # e "If you're interested, check out the Transitions Gallery section of this tutorial."
    e "興味があれば、このチュートリアルのトランジションのギャラリーの項目を参照して下さい。"

# game/tutorial_quickstart.rpy:439
translate japanese tutorial_music_8b92efb7:

    # e "Another important part of a visual novel or simulation game is the soundtrack."
    e "その他、ビジュアルノベルやシミュレーションゲームで重要なのはサウンドトラックです。"

# game/tutorial_quickstart.rpy:441
translate japanese tutorial_music_53910317:

    # e "Ren'Py breaks sound up into channels. The channel a sound is played on determines if the sound loops, and if it is saved and restored with the game."
    e "Ren'Pyではサウンドをチャンネルごとに分けられます。チャンネルのサウンドがループ再生に指定された場合、サウンドは保存され、ゲームと共に復元できます。"

# game/tutorial_quickstart.rpy:443
translate japanese tutorial_music_a1e37712:

    # e "When a sound is played on the music channel, it is looped, and it is saved when the game is saved."
    e "サウンドが music チャンネルで再生されるときは、サウンドはループ再生され、ゲームをセーブするときに一緒に保存されます。"

# game/tutorial_quickstart.rpy:445
translate japanese tutorial_music_d9086d22:

    # e "When the channel named sound is used, the sound is played once and then stopped. It isn't saved."
    e "サウンドが sound チャンネルで再生されるときは、サウンドは一回だけ再生されて停止し、保存はされません。"

# game/tutorial_quickstart.rpy:447
translate japanese tutorial_music_3555b640:

    # e "The sounds themselves are stored in audio files. Ren'Py supports the Opus, Ogg Vorbis, and mp3 formats."
    e "サウンド自体はオーディオファイルの中に保存されています。Ren'PyはOpus, Ogg Vorbis、mp3フォーマットをサポートしています。"

# game/tutorial_quickstart.rpy:449
translate japanese tutorial_music_a2ffbe9b:

    # e "Let's check out some of the commands that can affect the music channel."
    e "musicチャンネルに作用するいくつかのコマンドを見てみましょう。"

# game/tutorial_quickstart.rpy:454
translate japanese tutorial_music_8b606a55:

    # e "The play music command replaces the currently playing music, and replaces it with the named filename."
    e "play music コマンドは現在再生されている音楽を、指定したファイル名の音楽で置き換えます。"

# game/tutorial_quickstart.rpy:456
translate japanese tutorial_music_18650fe7:

    # e "If you specify the currently-playing song, it will restart it."
    e "現在再生されている曲を指定した場合は、もう一度始めから再生されます。"

# game/tutorial_quickstart.rpy:458
translate japanese tutorial_music_413d91fc:

    # e "If the optional fadeout clause is given, it will fade out the currently playing music before starting the new music."
    e "追加で fadeout 項が指定された場合、新しい音楽を再生する前に現在再生中の音楽をフェードアウトします。"

# game/tutorial_quickstart.rpy:463
translate japanese tutorial_music_a282a0e3:

    # e "The queue statement also adds music to the named channel, but it waits until the currently-playing song is finished before playing the new music."
    e "queue ステートメントも、音楽を決まった名前のチャンネルに追加します。しかし、これは音楽を再生する前に現在再生中の音楽が終了するのを待ちます。"

# game/tutorial_quickstart.rpy:468
translate japanese tutorial_music_01ca6bad:

    # e "The third statement is the stop statement. It stops the music playing on a channel. It too takes the fadeout clause."
    e "3つ目は stop ステートメントです。このステートメントはチャンネルで再生されている音楽を停止します。これも fadeout 項をとります。"

# game/tutorial_quickstart.rpy:473
translate japanese tutorial_music_384937da:

    # e "Unlike the music channel, playing a sound on the sound channel causes it to play only once."
    e "music チャンネルとは異なり、一回だけ再生する場合はサウンドを sound チャンネルで再生します。"

# game/tutorial_quickstart.rpy:480
translate japanese tutorial_music_1d3e9fd2:

    # e "You can queue up multiple sounds on the sound channel, but the sounds will only play one at a time."
    e "sound チャンネルには複数のサウンドをキューでき、これらは1つずつだけ再生されます。"

# game/tutorial_quickstart.rpy:486
translate japanese tutorial_music_aa01c19d:

    # e "Ren'Py has separate mixers for sound, music, and voices, so the player can adjust them as they like."
    e "Ren'Pyは sound、music、voices に独立したミキサーを持っているので、プレイヤーは好みに合わせてそれらを調整できます。"

# game/tutorial_quickstart.rpy:492
translate japanese tutorial_menus_0426904b:

    # e "Many visual novels require the player to make choices from in-game menus. These choices can add some challenge to the game, or adjust it to the player's preferences."
    e "多くのビジュアルノベルには、ゲーム内でプレイヤーに選択させるメニューがあります。これらの選択肢はゲームに手応えを与えたり、プレイヤーの設定を調整したりします。"

# game/tutorial_quickstart.rpy:494
translate japanese tutorial_menus_431eeff0:

    # e "Do you like to play visual novels with choices in them?"
    e "選択肢のあるヴィジュアルノベルをプレイしたいですか？"

# game/tutorial_quickstart.rpy:509
translate japanese choice1_yes_f6d95df8:

    # e "While creating a multi-path visual novel can be a bit more work, it can yield a unique experience."
    e "多分岐のビジュアルノベルを作っているときはちょっと大変ですが、他にない体験ができます。"

# game/tutorial_quickstart.rpy:517
translate japanese choice1_no_72958b50:

    # e "Games without menus are called kinetic novels, and there are dozens of them available to play."
    e "メニューのないゲームはキネティックノベルの言われ、遊べるものは数十あります。"

# game/tutorial_quickstart.rpy:528
translate japanese choice1_done_acba9504:

    # e "Here, you can see the code for that menu. If you scroll down, you can see the code we run after the menu."
    e "メニューのコードを示します。下にスクロールすると、メニューの後に実行されるコードを見ることができます。"

# game/tutorial_quickstart.rpy:530
translate japanese choice1_done_f9fa6889:

    # e "Menus are introduced by the menu statement. The menu statement takes an indented block, in which there can be one line of dialogue and multiple choices."
    e "メニューは menu ステートメントによって導入されます。menu ステートメントはインデントブロックをとり、内部に一行の台詞と複数の選択肢を配置できます"

# game/tutorial_quickstart.rpy:532
translate japanese choice1_done_ebb2db38:

    # e "Each choice must end with a colon, as each choice has its own block of Ren'Py code, that is run when that choice is selected."
    e "選択肢はコロンで終えなければならず、それぞれの選択肢にはそれが選択されたときに実行されるRen'Pyのブロックコードがあります。"

# game/tutorial_quickstart.rpy:534
translate japanese choice1_done_59cac95d:

    # e "Here, each block jumps to a label. While you could put small amounts of Ren'Py code inside a menu label, it's probably good practice to usually jump to a bigger block of code."
    e "ここでは、それぞれのブロックはラベルにジャンプします。メニューラベルの中に少量のRen'Pyコード書き、大きいブロックコードにジャンプするという習慣があるといいでしょう。"

# game/tutorial_quickstart.rpy:536
translate japanese choice1_done_2851a313:

    # e "Scrolling down past the menu, you can see the labels that the menu jumps to. There are three labels here, named choice1_yes, choice1_no, and choice1_done."
    e "メニューの下にスクロールすると、メニューのジャンプ先のラベルがあります。ここには3つのラベル choice1_yes、choice1_no、choice1_done があります。"

# game/tutorial_quickstart.rpy:538
translate japanese choice1_done_ff761b03:

    # e "When the first menu choice is picked, we jump to the choice1_yes, which runs two lines of script before jumping to choice1_done."
    e "1つ目のラベルを選ぶとchoice1_yesにジャンプし、choice1_doneにジャンプするまでのスクリプトの2行が実行されます。"

# game/tutorial_quickstart.rpy:540
translate japanese choice1_done_664fe702:

    # e "Similarly, picking the second choice jumps us to choice1_no, which also runs two lines of script."
    e "同様に、2つ目のラベルを選ぶとchoice1_noにジャンプし、同じく2行が実行されます。"

# game/tutorial_quickstart.rpy:542
translate japanese choice1_done_31d12b1e:

    # e "The lines beginning with the dollar sign are lines of python code, which are used to set a flag based on the user's choice."
    e "ドル記号から始まっている行はPythonコードの行で、ユーザーの選択によるフラグをセットするのに使います。"

# game/tutorial_quickstart.rpy:544
translate japanese choice1_done_88398d3e:

    # e "The flag is named menu_flag, and it's set to True or False based on the user's choice. The if statement can be used to test a flag, so the game can remember the user's choices."
    e "フラグの名前は menu_flag としており、ユーザーの選択によって True か False をセットします。if ステートメントはフラグを調べるために使えるので、ゲームでユーザーの選択を記憶できます。"

# game/tutorial_quickstart.rpy:549
translate japanese choice1_done_2828dbfc:

    # e "For example, I remember that you plan to use menus in your game."
    e "例えば、私はあなたがメニューがあるゲームを作るつもりだということを覚えています。"

# game/tutorial_quickstart.rpy:553
translate japanese choice1_done_503786e4:

    # e "For example, I remember that you're planning to make a kinetic novel, without menus."
    e "例えば、私はあなたがメニューがないキネティックノベルを作るつもりだということを覚えています。"

# game/tutorial_quickstart.rpy:555
translate japanese choice1_done_819e234a:

    # e "Here's an example that shows how we can test a flag, and do different things if it is true or not."
    e "どのようにフラグを調べ、真偽によって異なる処理をしたのか、例を示します。"

# game/tutorial_quickstart.rpy:559
translate japanese choice1_done_461e6a59:

    # e "Finally, this shows how you can show dialogue and menus at the same time. Understand?" nointeract
    e "つまり、ここではどのように台詞と選択肢を同時に表示するかを示しています。分かりましたか？" nointeract

# game/tutorial_quickstart.rpy:564
translate japanese choice1_done_a32e30fd:

    # e "Great."
    e "すばらしい"

# game/tutorial_quickstart.rpy:568
translate japanese choice1_done_fbd1dbc1:

    # e "If you look at the example, before the first choice, there's an indented say statement."
    e "例をみると最初の選択肢の前にsayステートメントがあります。"

# game/tutorial_quickstart.rpy:574
translate japanese menu3_done_47fa2268:

    # e "Although we won't demonstrate it here, Ren'Py supports making decisions based on a combinations of points, flags, and other factors."
    e "ここでは実演しませんが、Ren'Pyでは点数、フラグ、その他の要因による意思決定ができます。"

# game/tutorial_quickstart.rpy:576
translate japanese menu3_done_826a600b:

    # e "One of Ren'Py's big advantages is the flexibility using a scripting language like Python provides us. It lets us easily scale from kinetic novels to complex simulation games."
    e "Ren'Pyを使うことの大きなメリットの一つは、Pythonのスクリプト言語を使っていて柔軟なことです。これによりキネティックノベルから複雑なシミュレーションゲームまで幅広いものが簡単にできます。"

# game/tutorial_quickstart.rpy:585
translate japanese tutorial_input_066611c5:

    # e "Some games might prompt the player for input."
    e "ゲームによってはプレイヤーに入力を促します"

# game/tutorial_quickstart.rpy:599
translate japanese tutorial_input_dc3b4560:

    # e "That's done with Python, and especially the renpy.input function. The first line of this example prompts the player for some texts, and sticks it in the name variable."
    e "これはPython, 特にrenpy.input関数で実行されます。この例の最初の行はプレイヤーにテキストの入力を促し、それをname変数に格納します。"

# game/tutorial_quickstart.rpy:601
translate japanese tutorial_input_c88b3f4e:

    # e "Often times, you'll want to clean the name up before you use it. The last line does that, by calling the strip method to remove whitespace, and replacing the name with a default if it's missing."
    e "しばしば使用前にnameを整理したいでしょうが、最後の行でそれを行なっています。stripメソッドを呼びだして空白を除去し、nameが空ならデフォルトのもので置き換えます。"

# game/tutorial_quickstart.rpy:605
translate japanese tutorial_input_1236e9da:

    # e "To interpolate a variable, write it in square brackets. Isn't that right, [name]?"
    e "変数を補完するには、角括弧内に書きます。[name]でよろしいですね？"

# game/tutorial_quickstart.rpy:609
translate japanese tutorial_input_c1f7a808:

    # e "Variable names can also be shown in character names. To do that, just include the variable in square brackets in the character's name. Got it?"
    e "変数名はキャラクター名としても表示できます。それにはこのようにキャラクターの名前に角括弧で覆われた変数を含めるだけです。"

# game/tutorial_quickstart.rpy:612
translate japanese tutorial_input_f7757a8e:

    # g "I think I do."
    g "そうです。"

# game/tutorial_quickstart.rpy:619
translate japanese tutorial_input_0548d3e2:

    # e "Variable interpolation also works with other variables. Here, the answer is [answer] and the flag is [flag]."
    e "変数の補完は他の変数に対しても動作します。ここでは、answerは[answer]で、flagは[flag]です。"

translate japanese strings:

    # game/tutorial_quickstart.rpy:2
    old "Lucy"
    new "Lucy"

    # game/tutorial_quickstart.rpy:497
    old "Yes, I do."
    new "はい"

    # game/tutorial_quickstart.rpy:497
    old "No, I don't."
    new "いいえ"

    # game/tutorial_quickstart.rpy:589
    old "What's your name?"
    new "あなたの名前はなんでしょう"

    # game/tutorial_quickstart.rpy:591
    old "Guy Shy"
    new "恥しがりや"

# game/tutorial_quickstart.rpy:246
translate japanese tutorial_images_a5e7eb24:

    # e "The show statement adds a new image on top of all the other images on the screen."
    e "showステートメントはその画面の他のすべての画像の一番上に新しい画像を追加します"

# game/tutorial_quickstart.rpy:248
translate japanese tutorial_images_86e11de2:

    # e "If there is already an image with the same tag, the new image is used to replace the old one."
    e "同じタグの画像が既にあった場合は、古い画像が新しい画像に置き換えられます。"

