/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.ZipWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public abstract class Source {
    private final String name;
    private final byte[] nameBytes;
    public static final long NO_ALIGNMENT = 0L;
    private long alignment = 0L;
    protected long compressedSize;
    protected long uncompressedSize;
    protected int crc;
    protected short compressionFlag;
    protected short versionMadeBy;
    public static final short MADE_BY_UNIX = 768;
    private static final int TYPE_FREG = 32768;
    private static final int TYPE_FLNK = 40960;
    private static final int UNX_IRUSR = 256;
    private static final int UNX_IWUSR = 128;
    private static final int UNX_IXUSR = 64;
    private static final int UNX_IRGRP = 32;
    private static final int UNX_IWGRP = 16;
    private static final int UNX_IXGRP = 8;
    private static final int UNX_IROTH = 4;
    private static final int UNX_IWOTH = 2;
    private static final int UNX_IXOTH = 1;
    private static final int UNX_IRALL = 292;
    private static final int UNX_IWALL = 146;
    public static final int PERMISSION_USR_RW = 0x1800000;
    public static final int PERMISSION_RW = 28704768;
    public static final int PERMISSION_EXEC = 0x490000;
    public static final int PERMISSION_LINK = -1610612736;
    public static final int PERMISSION_DEFAULT = -2118778880;
    protected int externalAttributes;

    protected Source(String name) {
        this.name = name;
        this.nameBytes = name.getBytes(StandardCharsets.UTF_8);
        this.versionMadeBy = (short)768;
        this.externalAttributes = -2118778880;
    }

    public String getName() {
        return this.name;
    }

    byte[] getNameBytes() {
        return this.nameBytes;
    }

    boolean isAligned() {
        return this.alignment != 0L;
    }

    public void align(long alignment) {
        this.alignment = alignment;
    }

    long getAlignment() {
        return this.alignment;
    }

    int getCrc() {
        return this.crc;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    short getCompressionFlag() {
        return this.compressionFlag;
    }

    public short getVersionMadeBy() {
        return this.versionMadeBy;
    }

    public int getExternalAttributes() {
        return this.externalAttributes;
    }

    public void setExternalAttributes(int externalAttributes) {
        this.externalAttributes = externalAttributes;
    }

    public abstract void prepare() throws IOException;

    public abstract long writeTo(ZipWriter var1) throws IOException;
}

