/*
 * Decompiled with CFR 0.152.
 */
package com.android.apksig.internal.util;

import com.android.apksig.internal.util.DelegatingX509Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;

public class GuaranteedEncodedFormX509Certificate
extends DelegatingX509Certificate {
    private static final long serialVersionUID = 1L;
    private final byte[] mEncodedForm;
    private int mHash = -1;

    public GuaranteedEncodedFormX509Certificate(X509Certificate wrapped, byte[] encodedForm) {
        super(wrapped);
        this.mEncodedForm = encodedForm != null ? (byte[])encodedForm.clone() : null;
    }

    @Override
    public byte[] getEncoded() throws CertificateEncodingException {
        return this.mEncodedForm != null ? (byte[])this.mEncodedForm.clone() : null;
    }

    @Override
    public boolean equals(Object o11) {
        if (this == o11) {
            return true;
        }
        if (!(o11 instanceof X509Certificate)) {
            return false;
        }
        try {
            byte[] a11 = this.getEncoded();
            byte[] b11 = ((X509Certificate)o11).getEncoded();
            return Arrays.equals(a11, b11);
        }
        catch (CertificateEncodingException e11) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        if (this.mHash == -1) {
            try {
                this.mHash = Arrays.hashCode(this.getEncoded());
            }
            catch (CertificateEncodingException e11) {
                this.mHash = 0;
            }
        }
        return this.mHash;
    }
}

