/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.androidtools;

import com.android.tools.build.bundletool.androidtools.AutoValue_Aapt2Command_ConvertOptions;
import com.android.tools.build.bundletool.androidtools.CommandExecutor;
import com.android.tools.build.bundletool.androidtools.DefaultCommandExecutor;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Optional;

public interface Aapt2Command {
    public void convertApkProtoToBinary(Path var1, Path var2, ConvertOptions var3);

    public void optimizeToSparseResourceTables(Path var1, Path var2);

    default public ImmutableList<String> dumpBadging(Path apkPath) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public static Aapt2Command createFromExecutablePath(final Path aapt2Path) {
        return new Aapt2Command(){
            private final Duration timeoutMillis = Duration.ofMinutes(5L);

            @Override
            public void convertApkProtoToBinary(Path protoApk, Path binaryApk, ConvertOptions convertOptions) {
                ImmutableCollection.Builder convertCommand = ((ImmutableList.Builder)ImmutableList.builder().add(aapt2Path.toString())).add("convert");
                if (convertOptions.getForceSparseEncoding()) {
                    ((ImmutableList.Builder)convertCommand).add("--force-sparse-encoding");
                }
                if (convertOptions.getCollapseResourceNames()) {
                    ((ImmutableList.Builder)convertCommand).add("--collapse-resource-names");
                }
                if (convertOptions.getDeduplicateResourceEntries()) {
                    ((ImmutableList.Builder)convertCommand).add("--deduplicate-entry-values");
                }
                convertOptions.getResourceConfigPath().ifPresent(arg_0 -> 1.lambda$convertApkProtoToBinary$0((ImmutableList.Builder)convertCommand, arg_0));
                ((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)((ImmutableList.Builder)convertCommand).add("--output-format")).add("binary")).add("-o")).add(binaryApk.toString())).add(protoApk.toString());
                new DefaultCommandExecutor().execute((ImmutableList<String>)((ImmutableList.Builder)convertCommand).build(), CommandExecutor.CommandOptions.builder().setTimeout(this.timeoutMillis).build());
            }

            @Override
            public void optimizeToSparseResourceTables(Path originalApk, Path outputApk) {
                ImmutableList<String> convertCommand = ImmutableList.of(aapt2Path.toString(), "optimize", "--enable-sparse-encoding", "-o", outputApk.toString(), originalApk.toString());
                new DefaultCommandExecutor().execute(convertCommand, CommandExecutor.CommandOptions.builder().setTimeout(this.timeoutMillis).build());
            }

            @Override
            public ImmutableList<String> dumpBadging(Path apkPath) {
                return new DefaultCommandExecutor().executeAndCapture(ImmutableList.of(aapt2Path.toString(), "dump", "badging", apkPath.toString()), CommandExecutor.CommandOptions.builder().setTimeout(this.timeoutMillis).build());
            }

            private static /* synthetic */ void lambda$convertApkProtoToBinary$0(ImmutableList.Builder convertCommand, Path path) {
                ((ImmutableList.Builder)convertCommand.add("--resources-config-path")).add(path.toAbsolutePath().toString());
            }
        };
    }

    @AutoValue
    public static abstract class ConvertOptions {
        public abstract boolean getForceSparseEncoding();

        public abstract boolean getCollapseResourceNames();

        public abstract Optional<Path> getResourceConfigPath();

        public abstract boolean getDeduplicateResourceEntries();

        public static Builder builder() {
            return new AutoValue_Aapt2Command_ConvertOptions.Builder().setForceSparseEncoding(false).setCollapseResourceNames(false).setDeduplicateResourceEntries(false);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setForceSparseEncoding(boolean var1);

            public abstract Builder setCollapseResourceNames(boolean var1);

            public abstract Builder setResourceConfigPath(Optional<Path> var1);

            public abstract Builder setDeduplicateResourceEntries(boolean var1);

            public abstract ConvertOptions build();
        }
    }
}

