/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.transparency;

import com.android.bundle.CodeTransparencyOuterClass;
import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.transparency.CodeTransparencyCryptoUtils;
import com.android.tools.build.bundletool.transparency.CodeTransparencyFactory;
import com.android.tools.build.bundletool.transparency.CodeTransparencyVersion;
import com.android.tools.build.bundletool.transparency.TransparencyCheckResult;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.MapDifference;
import com.google.common.collect.Maps;
import com.google.common.io.ByteSource;
import java.util.Optional;
import java.util.logging.Logger;
import org.jose4j.jws.JsonWebSignature;

public final class BundleTransparencyCheckUtils {
    private static final Logger logger = Logger.getLogger(BundleTransparencyCheckUtils.class.getName());

    public static boolean isTransparencyEnabled(AppBundle bundle) {
        Optional<ByteSource> signedTransparencyFile = bundle.getBundleMetadata().getFileAsByteSource("com.android.tools.build.bundletool", "code_transparency_signed.jwt");
        return signedTransparencyFile.isPresent();
    }

    public static TransparencyCheckResult checkTransparency(AppBundle bundle) {
        Optional<ByteSource> signedTransparencyFile = bundle.getBundleMetadata().getFileAsByteSource("com.android.tools.build.bundletool", "code_transparency_signed.jwt");
        if (!signedTransparencyFile.isPresent()) {
            throw InvalidBundleException.builder().withUserMessage("Bundle does not include code transparency metadata. Run `add-transparency` command to add code transparency metadata to the bundle.").build();
        }
        return BundleTransparencyCheckUtils.checkTransparency(bundle, signedTransparencyFile.get());
    }

    public static TransparencyCheckResult checkTransparency(AppBundle bundle, ByteSource signedTransparencyFile) {
        TransparencyCheckResult.Builder result = TransparencyCheckResult.builder();
        JsonWebSignature jws = CodeTransparencyCryptoUtils.parseJws(signedTransparencyFile);
        if (!CodeTransparencyCryptoUtils.verifySignature(jws)) {
            return result.errorMessage("Verification failed because code transparency signature is invalid.").build();
        }
        result.transparencySignatureVerified(true).transparencyKeyCertificateFingerprint(CodeTransparencyCryptoUtils.getCertificateFingerprint(jws));
        CodeTransparencyOuterClass.CodeTransparency parsedTransparencyFile = CodeTransparencyFactory.parseFrom(jws.getUnverifiedPayload());
        CodeTransparencyVersion.checkVersion(parsedTransparencyFile);
        MapDifference<String, CodeTransparencyOuterClass.CodeRelatedFile> difference = Maps.difference(BundleTransparencyCheckUtils.getCodeRelatedFilesFromParsedTransparencyFile(parsedTransparencyFile), BundleTransparencyCheckUtils.getCodeRelatedFilesFromBundle(bundle));
        result.fileContentsVerified(difference.areEqual());
        if (!difference.areEqual()) {
            result.errorMessage(BundleTransparencyCheckUtils.getDiffAsString(difference));
        }
        return result.build();
    }

    private static ImmutableMap<String, CodeTransparencyOuterClass.CodeRelatedFile> getCodeRelatedFilesFromParsedTransparencyFile(CodeTransparencyOuterClass.CodeTransparency parsedTransparencyFile) {
        return parsedTransparencyFile.getCodeRelatedFileList().stream().map(BundleTransparencyCheckUtils::addTypeToDexCodeRelatedFiles).collect(ImmutableMap.toImmutableMap(BundleTransparencyCheckUtils::getSource, codeRelatedFile -> codeRelatedFile));
    }

    private static CodeTransparencyOuterClass.CodeRelatedFile addTypeToDexCodeRelatedFiles(CodeTransparencyOuterClass.CodeRelatedFile codeRelatedFile) {
        if (codeRelatedFile.getType().equals(CodeTransparencyOuterClass.CodeRelatedFile.Type.TYPE_UNSPECIFIED) && codeRelatedFile.getPath().endsWith(".dex")) {
            return codeRelatedFile.toBuilder().setType(CodeTransparencyOuterClass.CodeRelatedFile.Type.DEX).build();
        }
        return codeRelatedFile;
    }

    private static ImmutableMap<String, CodeTransparencyOuterClass.CodeRelatedFile> getCodeRelatedFilesFromBundle(AppBundle bundle) {
        return CodeTransparencyFactory.createCodeTransparencyMetadata(bundle).getCodeRelatedFileList().stream().collect(ImmutableMap.toImmutableMap(BundleTransparencyCheckUtils::getSource, codeRelatedFile -> codeRelatedFile));
    }

    private static String getSource(CodeTransparencyOuterClass.CodeRelatedFile codeRelatedFile) {
        switch (codeRelatedFile.getSourceCase()) {
            case PATH: {
                return codeRelatedFile.getPath();
            }
            case BUNDLETOOL_REPO_PATH: {
                return codeRelatedFile.getBundletoolRepoPath();
            }
            case SOURCE_NOT_SET: {
                logger.warning("CodeRelatedFile has unset `source`: " + codeRelatedFile);
            }
        }
        throw InvalidBundleException.builder().withUserMessage("Failed to get value of `source`").build();
    }

    private static String getDiffAsString(MapDifference<String, CodeTransparencyOuterClass.CodeRelatedFile> codeTransparencyDiff) {
        if (codeTransparencyDiff.areEqual()) {
            return "";
        }
        return "Verification failed because code was modified after transparency metadata generation. \nFiles deleted after transparency metadata generation: " + codeTransparencyDiff.entriesOnlyOnLeft().keySet() + "\nFiles added after transparency metadata generation: " + codeTransparencyDiff.entriesOnlyOnRight().keySet() + "\nFiles modified after transparency metadata generation: " + codeTransparencyDiff.entriesDiffering().keySet();
    }

    private BundleTransparencyCheckUtils() {
    }
}

