/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.keys.resolvers;

import java.security.Key;
import java.util.List;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.DecryptionJwkSelector;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.PublicJsonWebKey;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.resolvers.DecryptionKeyResolver;
import org.jose4j.lang.JoseException;
import org.jose4j.lang.UnresolvableKeyException;

public class JwksDecryptionKeyResolver
implements DecryptionKeyResolver {
    private List<JsonWebKey> jsonWebKeys;
    private DecryptionJwkSelector selector = new DecryptionJwkSelector();

    public JwksDecryptionKeyResolver(List<JsonWebKey> jsonWebKeys) {
        this.jsonWebKeys = jsonWebKeys;
    }

    @Override
    public Key resolveKey(JsonWebEncryption jwe, List<JsonWebStructure> nestingContext) throws UnresolvableKeyException {
        JsonWebKey selected;
        try {
            selected = this.selector.select(jwe, this.jsonWebKeys);
        }
        catch (JoseException e11) {
            StringBuilder sb2 = new StringBuilder();
            sb2.append("Unable to find a suitable key for JWE w/ header ").append(jwe.getHeaders().getFullHeaderAsJsonString());
            sb2.append(" due to an unexpected exception (").append(e11).append(") selecting from keys: ").append(this.jsonWebKeys);
            throw new UnresolvableKeyException(sb2.toString(), e11);
        }
        if (selected == null) {
            StringBuilder sb3 = new StringBuilder();
            sb3.append("Unable to find a suitable key for JWE w/ header ").append(jwe.getHeaders().getFullHeaderAsJsonString());
            sb3.append(" from JWKs ").append(this.jsonWebKeys);
            throw new UnresolvableKeyException(sb3.toString());
        }
        return selected instanceof PublicJsonWebKey ? ((PublicJsonWebKey)selected).getPrivateKey() : selected.getKey();
    }
}

