/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.jwt.consumer;

import java.util.List;
import java.util.Set;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.consumer.ErrorCodeValidator;
import org.jose4j.jwt.consumer.JwtContext;

public class AudValidator
implements ErrorCodeValidator {
    private static final ErrorCodeValidator.Error MISSING_AUD = new ErrorCodeValidator.Error(7, "No Audience (aud) claim present.");
    private Set<String> acceptableAudiences;
    private boolean requireAudience;

    public AudValidator(Set<String> acceptableAudiences, boolean requireAudience) {
        this.acceptableAudiences = acceptableAudiences;
        this.requireAudience = requireAudience;
    }

    @Override
    public ErrorCodeValidator.Error validate(JwtContext jwtContext) throws MalformedClaimException {
        JwtClaims jwtClaims = jwtContext.getJwtClaims();
        if (!jwtClaims.hasAudience()) {
            return this.requireAudience ? MISSING_AUD : null;
        }
        List<String> audiences = jwtClaims.getAudience();
        boolean ok2 = false;
        for (String audience : audiences) {
            if (!this.acceptableAudiences.contains(audience)) continue;
            ok2 = true;
        }
        if (!ok2) {
            StringBuilder sb2 = new StringBuilder();
            sb2.append("Audience (aud) claim ").append(audiences);
            if (this.acceptableAudiences.isEmpty()) {
                sb2.append(" present in the JWT but no expected audience value(s) were provided to the JWT Consumer.");
            } else {
                sb2.append(" doesn't contain an acceptable identifier.");
            }
            sb2.append(" Expected ");
            if (this.acceptableAudiences.size() == 1) {
                sb2.append(this.acceptableAudiences.iterator().next());
            } else {
                sb2.append("one of ").append(this.acceptableAudiences);
            }
            sb2.append(" as an aud value.");
            return new ErrorCodeValidator.Error(8, sb2.toString());
        }
        return null;
    }
}

