/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.signedness;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.checkerframework.checker.signedness.qual.Unsigned;

public final class SignednessUtil {
    private SignednessUtil() {
        throw new Error("Do not instantiate");
    }

    public static ByteBuffer wrapUnsigned(@Unsigned byte[] array) {
        return ByteBuffer.wrap(array);
    }

    public static ByteBuffer wrapUnsigned(@Unsigned byte[] array, int offset, int length) {
        return ByteBuffer.wrap(array, offset, length);
    }

    public static @Unsigned int getUnsignedInt(ByteBuffer b11) {
        return b11.getInt();
    }

    public static @Unsigned short getUnsignedShort(ByteBuffer b11) {
        return b11.getShort();
    }

    public static @Unsigned byte getUnsigned(ByteBuffer b11) {
        return b11.get();
    }

    public static @Unsigned byte getUnsigned(ByteBuffer b11, int i11) {
        return b11.get(i11);
    }

    public static ByteBuffer getUnsigned(ByteBuffer b11, byte[] bs2, int i11, int l11) {
        return b11.get(bs2, i11, l11);
    }

    public static ByteBuffer putUnsigned(ByteBuffer b11, @Unsigned byte ubyte) {
        return b11.put(ubyte);
    }

    public static ByteBuffer putUnsigned(ByteBuffer b11, int i11, @Unsigned byte ubyte) {
        return b11.put(i11, ubyte);
    }

    public static IntBuffer putUnsigned(IntBuffer b11, @Unsigned int uint) {
        return b11.put(uint);
    }

    public static IntBuffer putUnsigned(IntBuffer b11, int i11, @Unsigned int uint) {
        return b11.put(i11, uint);
    }

    public static IntBuffer putUnsigned(IntBuffer b11, @Unsigned int[] uints) {
        return b11.put(uints);
    }

    public static IntBuffer putUnsigned(IntBuffer b11, @Unsigned int[] uints, int i11, int l11) {
        return b11.put(uints, i11, l11);
    }

    public static @Unsigned int getUnsigned(IntBuffer b11, int i11) {
        return b11.get(i11);
    }

    public static ByteBuffer putUnsignedShort(ByteBuffer b11, @Unsigned short ushort) {
        return b11.putShort(ushort);
    }

    public static ByteBuffer putUnsignedShort(ByteBuffer b11, int i11, @Unsigned short ushort) {
        return b11.putShort(i11, ushort);
    }

    public static ByteBuffer putUnsignedInt(ByteBuffer b11, @Unsigned int uint) {
        return b11.putInt(uint);
    }

    public static ByteBuffer putUnsignedInt(ByteBuffer b11, int i11, @Unsigned int uint) {
        return b11.putInt(i11, uint);
    }

    public static ByteBuffer putUnsignedLong(ByteBuffer b11, int i11, @Unsigned long ulong) {
        return b11.putLong(i11, ulong);
    }

    public static @Unsigned char readUnsignedChar(RandomAccessFile f11) throws IOException {
        return f11.readChar();
    }

    public static @Unsigned int readUnsignedInt(RandomAccessFile f11) throws IOException {
        return f11.readInt();
    }

    public static @Unsigned long readUnsignedLong(RandomAccessFile f11) throws IOException {
        return f11.readLong();
    }

    public static int readUnsigned(RandomAccessFile f11, @Unsigned byte[] b11, int off, int len) throws IOException {
        return f11.read(b11, off, len);
    }

    public static void readFullyUnsigned(RandomAccessFile f11, @Unsigned byte[] b11) throws IOException {
        f11.readFully(b11);
    }

    public static void writeUnsigned(RandomAccessFile f11, @Unsigned byte[] bs2, int off, int len) throws IOException {
        f11.write(bs2, off, len);
    }

    public static void writeUnsignedByte(RandomAccessFile f11, @Unsigned byte b11) throws IOException {
        f11.writeByte(Byte.toUnsignedInt(b11));
    }

    public static void writeUnsignedChar(RandomAccessFile f11, @Unsigned char c11) throws IOException {
        f11.writeChar(SignednessUtil.toUnsignedInt(c11));
    }

    public static void writeUnsignedShort(RandomAccessFile f11, @Unsigned short s11) throws IOException {
        f11.writeShort(Short.toUnsignedInt(s11));
    }

    public static void writeUnsignedInt(RandomAccessFile f11, @Unsigned int i11) throws IOException {
        f11.writeInt(i11);
    }

    public static void writeUnsignedLong(RandomAccessFile f11, @Unsigned long l11) throws IOException {
        f11.writeLong(l11);
    }

    public static void getUnsigned(ByteBuffer b11, @Unsigned byte[] bs2) {
        b11.get(bs2);
    }

    public static int compareUnsigned(@Unsigned short x11, @Unsigned short y11) {
        return Integer.compareUnsigned(Short.toUnsignedInt(x11), Short.toUnsignedInt(y11));
    }

    public static int compareUnsigned(@Unsigned byte x11, @Unsigned byte y11) {
        return Integer.compareUnsigned(Byte.toUnsignedInt(x11), Byte.toUnsignedInt(y11));
    }

    public static String toUnsignedString(@Unsigned short s11) {
        return Long.toString(Short.toUnsignedLong(s11));
    }

    public static String toUnsignedString(@Unsigned short s11, int radix) {
        return Integer.toUnsignedString(Short.toUnsignedInt(s11), radix);
    }

    public static String toUnsignedString(@Unsigned byte b11) {
        return Integer.toUnsignedString(Byte.toUnsignedInt(b11));
    }

    public static String toUnsignedString(@Unsigned byte b11, int radix) {
        return Integer.toUnsignedString(Byte.toUnsignedInt(b11), radix);
    }

    private static @Unsigned BigInteger toUnsignedBigInteger(@Unsigned long l11) {
        if (l11 >= 0L) {
            return BigInteger.valueOf(l11);
        }
        int upper = (int)(l11 >>> 32);
        int lower = (int)l11;
        return BigInteger.valueOf(Integer.toUnsignedLong(upper)).shiftLeft(32).add(BigInteger.valueOf(Integer.toUnsignedLong(lower)));
    }

    public static @Unsigned short toUnsignedShort(@Unsigned byte b11) {
        return (short)(b11 & 0xFF);
    }

    public static @Unsigned long toUnsignedLong(@Unsigned char c11) {
        return (long)c11 & 0xFFL;
    }

    public static @Unsigned int toUnsignedInt(@Unsigned char c11) {
        return c11 & 0xFF;
    }

    public static @Unsigned short toUnsignedShort(@Unsigned char c11) {
        return (short)(c11 & 0xFF);
    }

    public static float toFloat(@Unsigned byte b11) {
        return SignednessUtil.toUnsignedBigInteger(Byte.toUnsignedLong(b11)).floatValue();
    }

    public static float toFloat(@Unsigned short s11) {
        return SignednessUtil.toUnsignedBigInteger(Short.toUnsignedLong(s11)).floatValue();
    }

    public static float toFloat(@Unsigned int i11) {
        return SignednessUtil.toUnsignedBigInteger(Integer.toUnsignedLong(i11)).floatValue();
    }

    public static float toFloat(@Unsigned long l11) {
        return SignednessUtil.toUnsignedBigInteger(l11).floatValue();
    }

    public static double toDouble(@Unsigned byte b11) {
        return SignednessUtil.toUnsignedBigInteger(Byte.toUnsignedLong(b11)).doubleValue();
    }

    public static double toDouble(@Unsigned short s11) {
        return SignednessUtil.toUnsignedBigInteger(Short.toUnsignedLong(s11)).doubleValue();
    }

    public static double toDouble(@Unsigned int i11) {
        return SignednessUtil.toUnsignedBigInteger(Integer.toUnsignedLong(i11)).doubleValue();
    }

    public static double toDouble(@Unsigned long l11) {
        return SignednessUtil.toUnsignedBigInteger(l11).doubleValue();
    }

    public static @Unsigned byte byteFromFloat(float f11) {
        assert (f11 >= 0.0f);
        return (byte)f11;
    }

    public static @Unsigned short shortFromFloat(float f11) {
        assert (f11 >= 0.0f);
        return (short)f11;
    }

    public static @Unsigned int intFromFloat(float f11) {
        assert (f11 >= 0.0f);
        return (int)f11;
    }

    public static @Unsigned long longFromFloat(float f11) {
        assert (f11 >= 0.0f);
        return (long)f11;
    }

    public static @Unsigned byte byteFromDouble(double d11) {
        assert (d11 >= 0.0);
        return (byte)d11;
    }

    public static @Unsigned short shortFromDouble(double d11) {
        assert (d11 >= 0.0);
        return (short)d11;
    }

    public static @Unsigned int intFromDouble(double d11) {
        assert (d11 >= 0.0);
        return (int)d11;
    }

    public static @Unsigned long longFromDouble(double d11) {
        assert (d11 >= 0.0);
        return (long)d11;
    }
}

