/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.bundle.Config;
import com.android.bundle.Targeting;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.Sets;

public final class BundleValidationUtils {
    public static void checkHasValuesOrAlternatives(Targeting.AbiTargeting targeting, String directoryPath) {
        if (targeting.getValueCount() == 0 && targeting.getAlternativesCount() == 0) {
            throw InvalidBundleException.builder().withUserMessage("Directory '%s' has set but empty ABI targeting.", directoryPath).build();
        }
    }

    public static void checkHasValuesOrAlternatives(Targeting.LanguageTargeting targeting, String directoryPath) {
        if (targeting.getValueCount() == 0 && targeting.getAlternativesCount() == 0) {
            throw InvalidBundleException.builder().withUserMessage("Directory '%s' has set but empty language targeting.", directoryPath).build();
        }
    }

    public static void checkHasValuesOrAlternatives(Targeting.TextureCompressionFormatTargeting targeting, String directoryPath) {
        if (targeting.getValueCount() == 0 && targeting.getAlternativesCount() == 0) {
            throw InvalidBundleException.builder().withUserMessage("Directory '%s' has set but empty Texture Compression Format targeting.", directoryPath).build();
        }
    }

    public static void checkHasValuesOrAlternatives(Targeting.CountrySetTargeting targeting, String directoryPath) {
        if (targeting.getValueCount() == 0 && targeting.getAlternativesCount() == 0) {
            throw InvalidBundleException.builder().withUserMessage("Directory '%s' has set but empty Country Set targeting.", directoryPath).build();
        }
    }

    public static void checkValuesAndAlternativeHaveNoOverlap(Targeting.AbiTargeting targeting, String directoryPath) {
        Sets.SetView intersection = Sets.intersection(targeting.getValueList().stream().map(Targeting.Abi::getAlias).collect(ImmutableSet.toImmutableSet()), targeting.getAlternativesList().stream().map(Targeting.Abi::getAlias).collect(ImmutableSet.toImmutableSet()));
        if (!intersection.isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("Expected targeting values and alternatives to be mutually exclusive, but directory '%s' has ABI targeting that contains %s in both.", directoryPath, intersection).build();
        }
    }

    public static void checkValuesAndAlternativeHaveNoOverlap(Targeting.LanguageTargeting targeting, String directoryPath) {
        Sets.SetView<String> intersection = Sets.intersection(ImmutableSet.copyOf(targeting.getValueList()), ImmutableSet.copyOf(targeting.getAlternativesList()));
        if (!intersection.isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("Expected targeting values and alternatives to be mutually exclusive, but directory '%s' has language targeting that contains %s in both.", directoryPath, intersection).build();
        }
    }

    public static void checkValuesAndAlternativeHaveNoOverlap(Targeting.TextureCompressionFormatTargeting targeting, String directoryPath) {
        Sets.SetView intersection = Sets.intersection(targeting.getValueList().stream().map(Targeting.TextureCompressionFormat::getAlias).collect(ImmutableSet.toImmutableSet()), targeting.getAlternativesList().stream().map(Targeting.TextureCompressionFormat::getAlias).collect(ImmutableSet.toImmutableSet()));
        if (!intersection.isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("Expected targeting values and alternatives to be mutually exclusive, but directory '%s' has texture compression format targeting that contains %s in both.", directoryPath, intersection).build();
        }
    }

    public static void checkValuesAndAlternativeHaveNoOverlap(Targeting.CountrySetTargeting targeting, String directoryPath) {
        Sets.SetView<String> intersection = Sets.intersection(ImmutableSet.copyOf(targeting.getValueList()), ImmutableSet.copyOf(targeting.getAlternativesList()));
        if (!intersection.isEmpty()) {
            throw InvalidBundleException.builder().withUserMessage("Expected targeting values and alternatives to be mutually exclusive, but directory '%s' has country set targeting that contains %s in both.", directoryPath, intersection).build();
        }
    }

    public static boolean directoryContainsNoFiles(BundleModule module, ZipPath dir) {
        return module.findEntriesUnderPath(dir).count() == 0L;
    }

    public static boolean isAssetOnlyBundle(ImmutableList<BundleModule> modules) {
        return ((Config.BundleConfig.BundleType)modules.stream().map(BundleModule::getBundleType).distinct().collect(MoreCollectors.toOptional()).orElseThrow(() -> InvalidBundleException.builder().withUserMessage("Bundle without modules.").build())).equals(Config.BundleConfig.BundleType.ASSET_ONLY);
    }

    public static BundleModule expectBaseModule(ImmutableList<BundleModule> modules) {
        return modules.stream().filter(BundleModule::isBaseModule).findFirst().orElseThrow(BundleValidationUtils::createNoBaseModuleException);
    }

    public static InvalidBundleException createNoBaseModuleException() {
        return InvalidBundleException.createWithUserMessage("App Bundle does not contain a mandatory 'base' module.");
    }

    private BundleValidationUtils() {
    }
}

