/*
 * Decompiled with CFR 0.152.
 */
package org.jose4j.json.internal.json_simple;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Map;
import org.jose4j.json.internal.json_simple.JSONArray;
import org.jose4j.json.internal.json_simple.JSONAware;
import org.jose4j.json.internal.json_simple.JSONObject;
import org.jose4j.json.internal.json_simple.JSONStreamAware;
import org.jose4j.json.internal.json_simple.parser.JSONParser;
import org.jose4j.json.internal.json_simple.parser.ParseException;

public class JSONValue {
    public static Object parse(Reader in2) {
        try {
            JSONParser parser = new JSONParser();
            return parser.parse(in2);
        }
        catch (Exception e11) {
            return null;
        }
    }

    public static Object parse(String s11) {
        StringReader in2 = new StringReader(s11);
        return JSONValue.parse(in2);
    }

    public static Object parseWithException(Reader in2) throws IOException, ParseException {
        JSONParser parser = new JSONParser();
        return parser.parse(in2);
    }

    public static Object parseWithException(String s11) throws ParseException {
        JSONParser parser = new JSONParser();
        return parser.parse(s11);
    }

    public static void writeJSONString(Object value, Writer out) throws IOException {
        if (value == null) {
            out.write("null");
            return;
        }
        if (value instanceof String) {
            out.write(34);
            out.write(JSONValue.escape((String)value));
            out.write(34);
            return;
        }
        if (value instanceof Double) {
            if (((Double)value).isInfinite() || ((Double)value).isNaN()) {
                out.write("null");
            } else {
                out.write(value.toString());
            }
            return;
        }
        if (value instanceof Float) {
            if (((Float)value).isInfinite() || ((Float)value).isNaN()) {
                out.write("null");
            } else {
                out.write(value.toString());
            }
            return;
        }
        if (value instanceof Number) {
            out.write(value.toString());
            return;
        }
        if (value instanceof Boolean) {
            out.write(value.toString());
            return;
        }
        if (value instanceof JSONStreamAware) {
            ((JSONStreamAware)value).writeJSONString(out);
            return;
        }
        if (value instanceof JSONAware) {
            out.write(((JSONAware)value).toJSONString());
            return;
        }
        if (value instanceof Map) {
            JSONObject.writeJSONString((Map)value, out);
            return;
        }
        if (value instanceof Collection) {
            JSONArray.writeJSONString((Collection)value, out);
            return;
        }
        if (value instanceof byte[]) {
            JSONArray.writeJSONString((byte[])value, out);
            return;
        }
        if (value instanceof short[]) {
            JSONArray.writeJSONString((short[])value, out);
            return;
        }
        if (value instanceof int[]) {
            JSONArray.writeJSONString((int[])value, out);
            return;
        }
        if (value instanceof long[]) {
            JSONArray.writeJSONString((long[])value, out);
            return;
        }
        if (value instanceof float[]) {
            JSONArray.writeJSONString((float[])value, out);
            return;
        }
        if (value instanceof double[]) {
            JSONArray.writeJSONString((double[])value, out);
            return;
        }
        if (value instanceof boolean[]) {
            JSONArray.writeJSONString((boolean[])value, out);
            return;
        }
        if (value instanceof char[]) {
            JSONArray.writeJSONString((char[])value, out);
            return;
        }
        if (value instanceof Object[]) {
            JSONArray.writeJSONString((Object[])value, out);
            return;
        }
        JSONValue.writeJSONString(value.toString(), out);
    }

    public static String toJSONString(Object value) {
        StringWriter writer = new StringWriter();
        try {
            JSONValue.writeJSONString(value, writer);
            return writer.toString();
        }
        catch (IOException e11) {
            throw new RuntimeException(e11);
        }
    }

    public static String escape(String s11) {
        if (s11 == null) {
            return null;
        }
        StringBuilder sb2 = new StringBuilder();
        JSONValue.escape(s11, sb2);
        return sb2.toString();
    }

    static void escape(String s11, StringBuilder sb2) {
        int len = s11.length();
        block9: for (int i11 = 0; i11 < len; ++i11) {
            char ch2 = s11.charAt(i11);
            switch (ch2) {
                case '\"': {
                    sb2.append("\\\"");
                    continue block9;
                }
                case '\\': {
                    sb2.append("\\\\");
                    continue block9;
                }
                case '\b': {
                    sb2.append("\\b");
                    continue block9;
                }
                case '\f': {
                    sb2.append("\\f");
                    continue block9;
                }
                case '\n': {
                    sb2.append("\\n");
                    continue block9;
                }
                case '\r': {
                    sb2.append("\\r");
                    continue block9;
                }
                case '\t': {
                    sb2.append("\\t");
                    continue block9;
                }
                default: {
                    if (ch2 >= '\u0000' && ch2 <= '\u001f' || ch2 >= '\u007f' && ch2 <= '\u009f' || ch2 >= '\u2000' && ch2 <= '\u20ff') {
                        String ss2 = Integer.toHexString(ch2);
                        sb2.append("\\u");
                        for (int k11 = 0; k11 < 4 - ss2.length(); ++k11) {
                            sb2.append('0');
                        }
                        sb2.append(ss2.toUpperCase());
                        continue block9;
                    }
                    sb2.append(ch2);
                }
            }
        }
    }
}

