/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.optimizations;

import com.android.bundle.Config;
import com.android.tools.build.bundletool.model.OptimizationDimension;
import com.android.tools.build.bundletool.model.version.Version;
import com.android.tools.build.bundletool.optimizations.AutoValue_ApkOptimizations;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Sets;
import com.google.errorprone.annotations.Immutable;

@Immutable
@AutoValue
@AutoValue.CopyAnnotations
public abstract class ApkOptimizations {
    private static final ImmutableSortedMap<Version, ApkOptimizations> DEFAULT_OPTIMIZATIONS_BY_BUNDLETOOL_VERSION = ((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)((ImmutableSortedMap.Builder)ImmutableSortedMap.naturalOrder().put(Version.of("0.0.0-dev"), ApkOptimizations.builder().setSplitDimensions(ImmutableSet.of(OptimizationDimension.ABI, OptimizationDimension.SCREEN_DENSITY, OptimizationDimension.LANGUAGE)).setStandaloneDimensions(ImmutableSet.of(OptimizationDimension.ABI, OptimizationDimension.SCREEN_DENSITY)).build())).put(Version.of("0.6.0"), ApkOptimizations.builder().setSplitDimensions(ImmutableSet.of(OptimizationDimension.ABI, OptimizationDimension.SCREEN_DENSITY, OptimizationDimension.LANGUAGE)).setUncompressNativeLibraries(true).setStandaloneDimensions(ImmutableSet.of(OptimizationDimension.ABI, OptimizationDimension.SCREEN_DENSITY)).build())).put(Version.of("0.10.2"), ApkOptimizations.builder().setSplitDimensions(ImmutableSet.of(OptimizationDimension.ABI, OptimizationDimension.SCREEN_DENSITY, OptimizationDimension.TEXTURE_COMPRESSION_FORMAT, OptimizationDimension.LANGUAGE)).setUncompressNativeLibraries(true).setStandaloneDimensions(ImmutableSet.of(OptimizationDimension.ABI, OptimizationDimension.SCREEN_DENSITY)).build())).put(Version.of("1.11.3"), ApkOptimizations.builder().setSplitDimensions(ImmutableSet.of(OptimizationDimension.ABI, OptimizationDimension.SCREEN_DENSITY, OptimizationDimension.TEXTURE_COMPRESSION_FORMAT, OptimizationDimension.LANGUAGE)).setUncompressNativeLibraries(true).setStandaloneDimensions(ImmutableSet.of(OptimizationDimension.ABI, OptimizationDimension.SCREEN_DENSITY)).setUncompressDexFiles(true).setUncompressedDexTargetSdk(Config.UncompressDexFiles.UncompressedDexTargetSdk.SDK_31).build())).put(Version.of("1.13.2"), ApkOptimizations.builder().setSplitDimensions(ImmutableSet.of(OptimizationDimension.ABI, OptimizationDimension.SCREEN_DENSITY, OptimizationDimension.TEXTURE_COMPRESSION_FORMAT, OptimizationDimension.LANGUAGE, OptimizationDimension.DEVICE_TIER)).setUncompressNativeLibraries(true).setStandaloneDimensions(ImmutableSet.of(OptimizationDimension.ABI, OptimizationDimension.SCREEN_DENSITY)).setUncompressDexFiles(true).setUncompressedDexTargetSdk(Config.UncompressDexFiles.UncompressedDexTargetSdk.SDK_31).build())).buildOrThrow();
    private static final ImmutableSet<OptimizationDimension> DIMENSIONS_SUPPORTED_BY_ASSET_MODULES = ImmutableSet.of(OptimizationDimension.LANGUAGE, OptimizationDimension.TEXTURE_COMPRESSION_FORMAT, OptimizationDimension.DEVICE_TIER, OptimizationDimension.COUNTRY_SET);

    public abstract ImmutableSet<OptimizationDimension> getSplitDimensions();

    public ImmutableSet<OptimizationDimension> getSplitDimensionsForAssetModules() {
        return Sets.intersection(this.getSplitDimensions(), DIMENSIONS_SUPPORTED_BY_ASSET_MODULES).immutableCopy();
    }

    public abstract boolean getUncompressNativeLibraries();

    public abstract boolean getUncompressDexFiles();

    public abstract Config.UncompressDexFiles.UncompressedDexTargetSdk getUncompressedDexTargetSdk();

    public abstract ImmutableSet<OptimizationDimension> getStandaloneDimensions();

    public abstract ImmutableMap<OptimizationDimension, Config.SuffixStripping> getSuffixStrippings();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_ApkOptimizations.Builder().setUncompressNativeLibraries(false).setUncompressDexFiles(false).setUncompressedDexTargetSdk(Config.UncompressDexFiles.UncompressedDexTargetSdk.UNSPECIFIED).setSuffixStrippings(ImmutableMap.of());
    }

    public static ApkOptimizations getDefaultOptimizationsForVersion(Version bundleToolVersion) {
        return Preconditions.checkNotNull(DEFAULT_OPTIMIZATIONS_BY_BUNDLETOOL_VERSION.floorEntry(bundleToolVersion), "No default optimizations found for BundleTool version %s.", (Object)bundleToolVersion).getValue();
    }

    public static ApkOptimizations getOptimizationsForUniversalApk() {
        return ApkOptimizations.builder().setSplitDimensions(ImmutableSet.of()).setStandaloneDimensions(ImmutableSet.of()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setSplitDimensions(ImmutableSet<OptimizationDimension> var1);

        public abstract Builder setUncompressNativeLibraries(boolean var1);

        public abstract Builder setUncompressDexFiles(boolean var1);

        public abstract Builder setUncompressedDexTargetSdk(Config.UncompressDexFiles.UncompressedDexTargetSdk var1);

        public abstract Builder setStandaloneDimensions(ImmutableSet<OptimizationDimension> var1);

        public abstract Builder setSuffixStrippings(ImmutableMap<OptimizationDimension, Config.SuffixStripping> var1);

        public abstract ApkOptimizations build();
    }
}

