/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model.exceptions;

import com.android.tools.build.bundletool.model.exceptions.BundleToolException;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import javax.annotation.Nullable;

public class InternalExceptionBuilder<T extends BundleToolException> {
    private final ExceptionCreator<T> creator;
    @Nullable
    protected Throwable cause;
    @Nullable
    protected String internalMessage;

    InternalExceptionBuilder(ExceptionCreator<T> creator) {
        this.creator = creator;
    }

    public InternalExceptionBuilder<T> withInternalMessage(String internalMessage) {
        this.internalMessage = internalMessage;
        return this;
    }

    @FormatMethod
    public InternalExceptionBuilder<T> withInternalMessage(@FormatString String message2, Object ... args2) {
        this.internalMessage = String.format(Preconditions.checkNotNull(message2), args2);
        return this;
    }

    public InternalExceptionBuilder<T> withCause(Throwable cause) {
        this.cause = cause;
        return this;
    }

    @CheckReturnValue
    public T build() {
        String effectiveInternalMessage = this.internalMessage == null ? (this.cause == null ? "" : this.cause.toString()) : this.internalMessage;
        return this.creator.create("", effectiveInternalMessage, this.cause);
    }

    @FunctionalInterface
    static interface ExceptionCreator<T extends BundleToolException> {
        public T create(String var1, String var2, Throwable var3);
    }
}

