/*
 * Decompiled with CFR 0.152.
 */
package com.android.zipflinger;

import com.android.zipflinger.Compressor;
import com.android.zipflinger.Entry;
import com.android.zipflinger.Location;
import com.android.zipflinger.PayloadInputStream;
import com.android.zipflinger.Zip64;
import com.android.zipflinger.ZipMap;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Map;

public class ZipRepo
implements Closeable {
    private final ZipMap zipMap;
    private final FileChannel channel;
    private final Path file;

    public ZipRepo(String filePath) throws IOException {
        this(ZipMap.from(Paths.get(filePath, new String[0]), false, Zip64.Policy.ALLOW));
    }

    public ZipRepo(Path path) throws IOException {
        this(ZipMap.from(path, false, Zip64.Policy.ALLOW));
    }

    public ZipRepo(ZipMap zipMap) throws IOException {
        this.zipMap = zipMap;
        this.channel = FileChannel.open(zipMap.getPath(), StandardOpenOption.READ);
        this.file = zipMap.getPath();
    }

    public Map<String, Entry> getEntries() {
        return this.zipMap.getEntries();
    }

    ZipMap getZipMap() {
        return this.zipMap;
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }

    private Entry getEntry(String entryName) {
        Entry entry = this.zipMap.getEntries().get(entryName);
        if (entry == null) {
            String msg = String.format("No entry '%s' in file '%s'", entryName, this.file);
            throw new IllegalArgumentException(msg);
        }
        return entry;
    }

    public InputStream getInputStream(String entryName) throws IOException {
        Entry entry = this.getEntry(entryName);
        Location payloadLocation = entry.getPayloadLocation();
        PayloadInputStream inputStream = new PayloadInputStream(this.channel, payloadLocation);
        if (!entry.isCompressed()) {
            return inputStream;
        }
        return Compressor.wrapToInflate(inputStream);
    }

    public ByteBuffer getContent(String entryName) throws IOException {
        Entry entry = this.getEntry(entryName);
        Location payloadLocation = entry.getPayloadLocation();
        ByteBuffer payloadByteBuffer = ByteBuffer.allocate(Math.toIntExact(payloadLocation.size()));
        this.channel.read(payloadByteBuffer, payloadLocation.first);
        payloadByteBuffer.rewind();
        if (entry.isCompressed()) {
            return Compressor.inflate(payloadByteBuffer.array());
        }
        return payloadByteBuffer;
    }
}

