/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.formatter.qual;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;

public enum ConversionCategory {
    GENERAL("bBhHsS", null),
    CHAR("cC", Character.class, Byte.class, Short.class, Integer.class),
    INT("doxX", Byte.class, Short.class, Integer.class, Long.class, BigInteger.class),
    FLOAT("eEfgGaA", Float.class, Double.class, BigDecimal.class),
    TIME("tT", Long.class, Calendar.class, Date.class),
    CHAR_AND_INT(null, Byte.class, Short.class, Integer.class),
    INT_AND_TIME(null, Long.class),
    NULL(null, new Class[0]),
    UNUSED(null, null);

    public final Class<?> @Nullable [] types;
    public final @Nullable String chars;

    private ConversionCategory(String chars, Class<?> ... types) {
        this.chars = chars;
        if (types == null) {
            this.types = types;
        } else {
            ArrayList typesWithPrimitives = new ArrayList(types.length);
            for (Class<?> type : types) {
                typesWithPrimitives.add(type);
                Class<? extends Object> unwrapped = ConversionCategory.unwrapPrimitive(type);
                if (unwrapped == null) continue;
                typesWithPrimitives.add(unwrapped);
            }
            this.types = typesWithPrimitives.toArray(new Class[typesWithPrimitives.size()]);
        }
    }

    private static @Nullable Class<? extends Object> unwrapPrimitive(Class<?> c11) {
        if (c11 == Byte.class) {
            return Byte.TYPE;
        }
        if (c11 == Character.class) {
            return Character.TYPE;
        }
        if (c11 == Short.class) {
            return Short.TYPE;
        }
        if (c11 == Integer.class) {
            return Integer.TYPE;
        }
        if (c11 == Long.class) {
            return Long.TYPE;
        }
        if (c11 == Float.class) {
            return Float.TYPE;
        }
        if (c11 == Double.class) {
            return Double.TYPE;
        }
        if (c11 == Boolean.class) {
            return Boolean.TYPE;
        }
        return null;
    }

    public static ConversionCategory fromConversionChar(char c11) {
        for (ConversionCategory v11 : new ConversionCategory[]{GENERAL, CHAR, INT, FLOAT, TIME}) {
            if (!v11.chars.contains(String.valueOf(c11))) continue;
            return v11;
        }
        throw new IllegalArgumentException("Bad conversion character " + c11);
    }

    private static <E> Set<E> arrayToSet(E[] a11) {
        return new HashSet<E>(Arrays.asList(a11));
    }

    public static boolean isSubsetOf(ConversionCategory a11, ConversionCategory b11) {
        return ConversionCategory.intersect(a11, b11) == a11;
    }

    public static ConversionCategory intersect(ConversionCategory a11, ConversionCategory b11) {
        if (a11 == UNUSED) {
            return b11;
        }
        if (b11 == UNUSED) {
            return a11;
        }
        if (a11 == GENERAL) {
            return b11;
        }
        if (b11 == GENERAL) {
            return a11;
        }
        Set<Class<Class<?>>> as2 = ConversionCategory.arrayToSet(a11.types);
        Set<Class<?>> bs2 = ConversionCategory.arrayToSet(b11.types);
        as2.retainAll(bs2);
        for (ConversionCategory v11 : new ConversionCategory[]{CHAR, INT, FLOAT, TIME, CHAR_AND_INT, INT_AND_TIME, NULL}) {
            Set<Class<?>> vs2 = ConversionCategory.arrayToSet(v11.types);
            if (!vs2.equals(as2)) continue;
            return v11;
        }
        throw new RuntimeException();
    }

    public static ConversionCategory union(ConversionCategory a11, ConversionCategory b11) {
        if (a11 == UNUSED || b11 == UNUSED) {
            return UNUSED;
        }
        if (a11 == GENERAL || b11 == GENERAL) {
            return GENERAL;
        }
        if (a11 == CHAR_AND_INT && b11 == INT_AND_TIME || a11 == INT_AND_TIME && b11 == CHAR_AND_INT) {
            return INT;
        }
        Set<Class<?>> as2 = ConversionCategory.arrayToSet(a11.types);
        Set<Class<?>> bs2 = ConversionCategory.arrayToSet(b11.types);
        as2.addAll(bs2);
        for (ConversionCategory v11 : new ConversionCategory[]{NULL, CHAR_AND_INT, INT_AND_TIME, CHAR, INT, FLOAT, TIME}) {
            Set<Class<?>> vs2 = ConversionCategory.arrayToSet(v11.types);
            if (!vs2.equals(as2)) continue;
            return v11;
        }
        return GENERAL;
    }

    public boolean isAssignableFrom(Class<?> argType) {
        if (this.types == null) {
            return true;
        }
        if (argType == Void.TYPE) {
            return true;
        }
        for (Class<?> c11 : this.types) {
            if (!c11.isAssignableFrom(argType)) continue;
            return true;
        }
        return false;
    }

    @Pure
    public String toString() {
        StringBuilder sb2 = new StringBuilder();
        sb2.append(this.name());
        sb2.append(" conversion category");
        if (this.types == null || this.types.length == 0) {
            return sb2.toString();
        }
        StringJoiner sj2 = new StringJoiner(", ", "(one of: ", ")");
        for (Class<?> cls : this.types) {
            sj2.add(cls.getSimpleName());
        }
        sb2.append(" ");
        sb2.append(sj2);
        return sb2.toString();
    }
}

