/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.tools.build.bundletool.model.AutoValue_ModuleEntry;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.google.common.io.ByteSource;
import java.util.Optional;

abstract class $AutoValue_ModuleEntry
extends ModuleEntry {
    private final ZipPath path;
    private final Optional<ModuleEntry.ModuleEntryLocationInZipSource> fileLocation;
    private final boolean forceUncompressed;
    private final boolean shouldSign;
    private final ByteSource content;

    $AutoValue_ModuleEntry(ZipPath path, Optional<ModuleEntry.ModuleEntryLocationInZipSource> fileLocation, boolean forceUncompressed, boolean shouldSign, ByteSource content) {
        if (path == null) {
            throw new NullPointerException("Null path");
        }
        this.path = path;
        if (fileLocation == null) {
            throw new NullPointerException("Null fileLocation");
        }
        this.fileLocation = fileLocation;
        this.forceUncompressed = forceUncompressed;
        this.shouldSign = shouldSign;
        if (content == null) {
            throw new NullPointerException("Null content");
        }
        this.content = content;
    }

    @Override
    public ZipPath getPath() {
        return this.path;
    }

    @Override
    public Optional<ModuleEntry.ModuleEntryLocationInZipSource> getFileLocation() {
        return this.fileLocation;
    }

    @Override
    public boolean getForceUncompressed() {
        return this.forceUncompressed;
    }

    @Override
    public boolean getShouldSign() {
        return this.shouldSign;
    }

    @Override
    public ByteSource getContent() {
        return this.content;
    }

    public String toString() {
        return "ModuleEntry{path=" + this.path + ", fileLocation=" + this.fileLocation + ", forceUncompressed=" + this.forceUncompressed + ", shouldSign=" + this.shouldSign + ", content=" + this.content + "}";
    }

    @Override
    public ModuleEntry.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends ModuleEntry.Builder {
        private ZipPath path;
        private Optional<ModuleEntry.ModuleEntryLocationInZipSource> fileLocation = Optional.empty();
        private Boolean forceUncompressed;
        private Boolean shouldSign;
        private ByteSource content;

        Builder() {
        }

        private Builder(ModuleEntry source) {
            this.path = source.getPath();
            this.fileLocation = source.getFileLocation();
            this.forceUncompressed = source.getForceUncompressed();
            this.shouldSign = source.getShouldSign();
            this.content = source.getContent();
        }

        @Override
        public ModuleEntry.Builder setPath(ZipPath path) {
            if (path == null) {
                throw new NullPointerException("Null path");
            }
            this.path = path;
            return this;
        }

        @Override
        public ModuleEntry.Builder setFileLocation(Optional<ModuleEntry.ModuleEntryLocationInZipSource> fileLocation) {
            if (fileLocation == null) {
                throw new NullPointerException("Null fileLocation");
            }
            this.fileLocation = fileLocation;
            return this;
        }

        @Override
        public ModuleEntry.Builder setFileLocation(ModuleEntry.ModuleEntryLocationInZipSource fileLocation) {
            this.fileLocation = Optional.of(fileLocation);
            return this;
        }

        @Override
        public ModuleEntry.Builder setForceUncompressed(boolean forceUncompressed) {
            this.forceUncompressed = forceUncompressed;
            return this;
        }

        @Override
        public ModuleEntry.Builder setShouldSign(boolean shouldSign) {
            this.shouldSign = shouldSign;
            return this;
        }

        @Override
        public ModuleEntry.Builder setContent(ByteSource content) {
            if (content == null) {
                throw new NullPointerException("Null content");
            }
            this.content = content;
            return this;
        }

        @Override
        public ModuleEntry build() {
            String missing = "";
            if (this.path == null) {
                missing = missing + " path";
            }
            if (this.forceUncompressed == null) {
                missing = missing + " forceUncompressed";
            }
            if (this.shouldSign == null) {
                missing = missing + " shouldSign";
            }
            if (this.content == null) {
                missing = missing + " content";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_ModuleEntry(this.path, this.fileLocation, this.forceUncompressed, this.shouldSign, this.content);
        }
    }
}

