/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Ordering;
import com.google.common.collect.ParametricNullness;
import java.io.Serializable;
import java.util.Iterator;
import javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class ReverseOrdering<T>
extends Ordering<T>
implements Serializable {
    final Ordering<? super T> forwardOrder;
    private static final long serialVersionUID = 0L;

    ReverseOrdering(Ordering<? super T> forwardOrder) {
        this.forwardOrder = Preconditions.checkNotNull(forwardOrder);
    }

    @Override
    public int compare(@ParametricNullness T a11, @ParametricNullness T b11) {
        return this.forwardOrder.compare(b11, a11);
    }

    @Override
    public <S extends T> Ordering<S> reverse() {
        return this.forwardOrder;
    }

    @Override
    public <E extends T> E min(@ParametricNullness E a11, @ParametricNullness E b11) {
        return this.forwardOrder.max(a11, b11);
    }

    @Override
    public <E extends T> E min(@ParametricNullness E a11, @ParametricNullness E b11, @ParametricNullness E c11, E ... rest) {
        return this.forwardOrder.max(a11, b11, c11, rest);
    }

    @Override
    public <E extends T> E min(Iterator<E> iterator2) {
        return this.forwardOrder.max(iterator2);
    }

    @Override
    public <E extends T> E min(Iterable<E> iterable) {
        return this.forwardOrder.max(iterable);
    }

    @Override
    public <E extends T> E max(@ParametricNullness E a11, @ParametricNullness E b11) {
        return this.forwardOrder.min(a11, b11);
    }

    @Override
    public <E extends T> E max(@ParametricNullness E a11, @ParametricNullness E b11, @ParametricNullness E c11, E ... rest) {
        return this.forwardOrder.min(a11, b11, c11, rest);
    }

    @Override
    public <E extends T> E max(Iterator<E> iterator2) {
        return this.forwardOrder.min(iterator2);
    }

    @Override
    public <E extends T> E max(Iterable<E> iterable) {
        return this.forwardOrder.min(iterable);
    }

    public int hashCode() {
        return -this.forwardOrder.hashCode();
    }

    @Override
    public boolean equals(@CheckForNull Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ReverseOrdering) {
            ReverseOrdering that = (ReverseOrdering)object;
            return this.forwardOrder.equals(that.forwardOrder);
        }
        return false;
    }

    public String toString() {
        String string = String.valueOf(this.forwardOrder);
        return new StringBuilder(10 + String.valueOf(string).length()).append(string).append(".reverse()").toString();
    }
}

