/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.validation;

import com.android.tools.build.bundletool.model.SdkBundle;
import com.android.tools.build.bundletool.validation.BundleFilesValidator;
import com.android.tools.build.bundletool.validation.BundleZipValidator;
import com.android.tools.build.bundletool.validation.DexFilesValidator;
import com.android.tools.build.bundletool.validation.ResourceTableValidator;
import com.android.tools.build.bundletool.validation.SdkAndroidManifestValidator;
import com.android.tools.build.bundletool.validation.SdkBundleConfigValidator;
import com.android.tools.build.bundletool.validation.SdkBundleMandatoryFilesPresenceValidator;
import com.android.tools.build.bundletool.validation.SdkBundleModuleNameValidator;
import com.android.tools.build.bundletool.validation.SdkBundleModuleResourceIdValidator;
import com.android.tools.build.bundletool.validation.SdkModulesConfigValidator;
import com.android.tools.build.bundletool.validation.SdkModulesFileValidator;
import com.android.tools.build.bundletool.validation.SubValidator;
import com.android.tools.build.bundletool.validation.ValidatorRunner;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.zip.ZipFile;

public class SdkBundleValidator {
    @VisibleForTesting
    static final ImmutableList<SubValidator> DEFAULT_BUNDLE_FILE_SUB_VALIDATORS = ImmutableList.of(new BundleZipValidator(), new SdkBundleMandatoryFilesPresenceValidator());
    @VisibleForTesting
    static final ImmutableList<SubValidator> DEFAULT_BUNDLE_SUB_VALIDATORS = ImmutableList.of(new BundleFilesValidator(), new SdkBundleModuleNameValidator(), new DexFilesValidator(), new SdkAndroidManifestValidator(), new SdkBundleConfigValidator(), new SdkModulesConfigValidator(), new ResourceTableValidator(), new SdkBundleModuleResourceIdValidator());
    private final ImmutableList<SubValidator> allBundleFileSubValidators;
    private final ImmutableList<SubValidator> allBundleSubValidators;
    private final ImmutableList<SubValidator> extraModulesFileSubValidators;

    private SdkBundleValidator(ImmutableList<SubValidator> allBundleSubValidators, ImmutableList<SubValidator> allBundleFileSubValidators, ImmutableList<SubValidator> extraModulesFileSubValidators) {
        this.allBundleSubValidators = allBundleSubValidators;
        this.allBundleFileSubValidators = allBundleFileSubValidators;
        this.extraModulesFileSubValidators = extraModulesFileSubValidators;
    }

    public static SdkBundleValidator create() {
        return SdkBundleValidator.create(ImmutableList.of());
    }

    public static SdkBundleValidator create(ImmutableList<SubValidator> extraSubValidators) {
        return new SdkBundleValidator((ImmutableList<SubValidator>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(DEFAULT_BUNDLE_SUB_VALIDATORS)).addAll(extraSubValidators)).build(), (ImmutableList<SubValidator>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(DEFAULT_BUNDLE_FILE_SUB_VALIDATORS)).addAll(extraSubValidators)).build(), extraSubValidators);
    }

    public void validateFile(ZipFile bundleFile) {
        new ValidatorRunner(this.allBundleFileSubValidators).validateBundleZipFile(bundleFile);
    }

    public void validateModulesFile(ZipFile modulesFile) {
        SdkModulesFileValidator.create(this.extraModulesFileSubValidators).validate(modulesFile);
    }

    public void validate(SdkBundle bundle) {
        new ValidatorRunner(this.allBundleSubValidators).validateSdkBundle(bundle);
    }
}

