/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHashFunction;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.ElementTypesAreNonnullByDefault;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedBytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Immutable;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import javax.annotation.CheckForNull;

@Immutable
@ElementTypesAreNonnullByDefault
final class Murmur3_32HashFunction
extends AbstractHashFunction
implements Serializable {
    static final HashFunction MURMUR3_32 = new Murmur3_32HashFunction(0, false);
    static final HashFunction MURMUR3_32_FIXED = new Murmur3_32HashFunction(0, true);
    static final HashFunction GOOD_FAST_HASH_32 = new Murmur3_32HashFunction(Hashing.GOOD_FAST_HASH_SEED, true);
    private static final int CHUNK_SIZE = 4;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private final int seed;
    private final boolean supplementaryPlaneFix;
    private static final long serialVersionUID = 0L;

    Murmur3_32HashFunction(int seed, boolean supplementaryPlaneFix) {
        this.seed = seed;
        this.supplementaryPlaneFix = supplementaryPlaneFix;
    }

    @Override
    public int bits() {
        return 32;
    }

    @Override
    public Hasher newHasher() {
        return new Murmur3_32Hasher(this.seed);
    }

    public String toString() {
        int n11 = this.seed;
        return new StringBuilder(31).append("Hashing.murmur3_32(").append(n11).append(")").toString();
    }

    public boolean equals(@CheckForNull Object object) {
        if (object instanceof Murmur3_32HashFunction) {
            Murmur3_32HashFunction other = (Murmur3_32HashFunction)object;
            return this.seed == other.seed && this.supplementaryPlaneFix == other.supplementaryPlaneFix;
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().hashCode() ^ this.seed;
    }

    @Override
    public HashCode hashInt(int input) {
        int k12 = Murmur3_32HashFunction.mixK1(input);
        int h12 = Murmur3_32HashFunction.mixH1(this.seed, k12);
        return Murmur3_32HashFunction.fmix(h12, 4);
    }

    @Override
    public HashCode hashLong(long input) {
        int low = (int)input;
        int high = (int)(input >>> 32);
        int k12 = Murmur3_32HashFunction.mixK1(low);
        int h12 = Murmur3_32HashFunction.mixH1(this.seed, k12);
        k12 = Murmur3_32HashFunction.mixK1(high);
        h12 = Murmur3_32HashFunction.mixH1(h12, k12);
        return Murmur3_32HashFunction.fmix(h12, 8);
    }

    @Override
    public HashCode hashUnencodedChars(CharSequence input) {
        int h12 = this.seed;
        for (int i11 = 1; i11 < input.length(); i11 += 2) {
            int k12 = input.charAt(i11 - 1) | input.charAt(i11) << 16;
            k12 = Murmur3_32HashFunction.mixK1(k12);
            h12 = Murmur3_32HashFunction.mixH1(h12, k12);
        }
        if ((input.length() & 1) == 1) {
            int k13 = input.charAt(input.length() - 1);
            k13 = Murmur3_32HashFunction.mixK1(k13);
            h12 ^= k13;
        }
        return Murmur3_32HashFunction.fmix(h12, 2 * input.length());
    }

    @Override
    public HashCode hashString(CharSequence input, Charset charset) {
        if (Charsets.UTF_8.equals(charset)) {
            int k12;
            int utf16Length = input.length();
            int h12 = this.seed;
            int i11 = 0;
            int len = 0;
            while (i11 + 4 <= utf16Length) {
                char c02 = input.charAt(i11);
                char c12 = input.charAt(i11 + 1);
                char c22 = input.charAt(i11 + 2);
                char c32 = input.charAt(i11 + 3);
                if (c02 >= '\u0080' || c12 >= '\u0080' || c22 >= '\u0080' || c32 >= '\u0080') break;
                k12 = c02 | c12 << 8 | c22 << 16 | c32 << 24;
                k12 = Murmur3_32HashFunction.mixK1(k12);
                h12 = Murmur3_32HashFunction.mixH1(h12, k12);
                i11 += 4;
                len += 4;
            }
            long buffer = 0L;
            int shift = 0;
            while (i11 < utf16Length) {
                char c11 = input.charAt(i11);
                if (c11 < '\u0080') {
                    buffer |= (long)c11 << shift;
                    shift += 8;
                    ++len;
                } else if (c11 < '\u0800') {
                    buffer |= Murmur3_32HashFunction.charToTwoUtf8Bytes(c11) << shift;
                    shift += 16;
                    len += 2;
                } else if (c11 < '\ud800' || c11 > '\udfff') {
                    buffer |= Murmur3_32HashFunction.charToThreeUtf8Bytes(c11) << shift;
                    shift += 24;
                    len += 3;
                } else {
                    int codePoint = Character.codePointAt(input, i11);
                    if (codePoint == c11) {
                        return this.hashBytes(input.toString().getBytes(charset));
                    }
                    ++i11;
                    buffer |= Murmur3_32HashFunction.codePointToFourUtf8Bytes(codePoint) << shift;
                    if (this.supplementaryPlaneFix) {
                        shift += 32;
                    }
                    len += 4;
                }
                if (shift >= 32) {
                    k12 = Murmur3_32HashFunction.mixK1((int)buffer);
                    h12 = Murmur3_32HashFunction.mixH1(h12, k12);
                    buffer >>>= 32;
                    shift -= 32;
                }
                ++i11;
            }
            int k13 = Murmur3_32HashFunction.mixK1((int)buffer);
            return Murmur3_32HashFunction.fmix(h12 ^= k13, len);
        }
        return this.hashBytes(input.toString().getBytes(charset));
    }

    @Override
    public HashCode hashBytes(byte[] input, int off, int len) {
        int k12;
        Preconditions.checkPositionIndexes(off, off + len, input.length);
        int h12 = this.seed;
        int i11 = 0;
        while (i11 + 4 <= len) {
            k12 = Murmur3_32HashFunction.mixK1(Murmur3_32HashFunction.getIntLittleEndian(input, off + i11));
            h12 = Murmur3_32HashFunction.mixH1(h12, k12);
            i11 += 4;
        }
        k12 = 0;
        int shift = 0;
        while (i11 < len) {
            k12 ^= UnsignedBytes.toInt(input[off + i11]) << shift;
            ++i11;
            shift += 8;
        }
        return Murmur3_32HashFunction.fmix(h12 ^= Murmur3_32HashFunction.mixK1(k12), len);
    }

    private static int getIntLittleEndian(byte[] input, int offset) {
        return Ints.fromBytes(input[offset + 3], input[offset + 2], input[offset + 1], input[offset]);
    }

    private static int mixK1(int k12) {
        k12 *= -862048943;
        k12 = Integer.rotateLeft(k12, 15);
        return k12 *= 461845907;
    }

    private static int mixH1(int h12, int k12) {
        h12 ^= k12;
        h12 = Integer.rotateLeft(h12, 13);
        h12 = h12 * 5 + -430675100;
        return h12;
    }

    private static HashCode fmix(int h12, int length) {
        h12 ^= length;
        h12 ^= h12 >>> 16;
        h12 *= -2048144789;
        h12 ^= h12 >>> 13;
        h12 *= -1028477387;
        h12 ^= h12 >>> 16;
        return HashCode.fromInt(h12);
    }

    private static long codePointToFourUtf8Bytes(int codePoint) {
        return 0xF0L | (long)(codePoint >>> 18) | (0x80L | (long)(0x3F & codePoint >>> 12)) << 8 | (0x80L | (long)(0x3F & codePoint >>> 6)) << 16 | (0x80L | (long)(0x3F & codePoint)) << 24;
    }

    private static long charToThreeUtf8Bytes(char c11) {
        return 0xE0L | (long)(c11 >>> 12) | (long)((0x80 | 0x3F & c11 >>> 6) << 8) | (long)((0x80 | 0x3F & c11) << 16);
    }

    private static long charToTwoUtf8Bytes(char c11) {
        return 0xC0L | (long)(c11 >>> 6) | (long)((0x80 | 0x3F & c11) << 8);
    }

    @CanIgnoreReturnValue
    private static final class Murmur3_32Hasher
    extends AbstractHasher {
        private int h1;
        private long buffer;
        private int shift;
        private int length;
        private boolean isDone;

        Murmur3_32Hasher(int seed) {
            this.h1 = seed;
            this.length = 0;
            this.isDone = false;
        }

        private void update(int nBytes, long update) {
            this.buffer |= (update & 0xFFFFFFFFL) << this.shift;
            this.shift += nBytes * 8;
            this.length += nBytes;
            if (this.shift >= 32) {
                this.h1 = Murmur3_32HashFunction.mixH1(this.h1, Murmur3_32HashFunction.mixK1((int)this.buffer));
                this.buffer >>>= 32;
                this.shift -= 32;
            }
        }

        @Override
        public Hasher putByte(byte b11) {
            this.update(1, b11 & 0xFF);
            return this;
        }

        @Override
        public Hasher putBytes(byte[] bytes, int off, int len) {
            Preconditions.checkPositionIndexes(off, off + len, bytes.length);
            int i11 = 0;
            while (i11 + 4 <= len) {
                this.update(4, Murmur3_32HashFunction.getIntLittleEndian(bytes, off + i11));
                i11 += 4;
            }
            while (i11 < len) {
                this.putByte(bytes[off + i11]);
                ++i11;
            }
            return this;
        }

        @Override
        public Hasher putBytes(ByteBuffer buffer) {
            ByteOrder bo2 = buffer.order();
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            while (buffer.remaining() >= 4) {
                this.putInt(buffer.getInt());
            }
            while (buffer.hasRemaining()) {
                this.putByte(buffer.get());
            }
            buffer.order(bo2);
            return this;
        }

        @Override
        public Hasher putInt(int i11) {
            this.update(4, i11);
            return this;
        }

        @Override
        public Hasher putLong(long l11) {
            this.update(4, (int)l11);
            this.update(4, l11 >>> 32);
            return this;
        }

        @Override
        public Hasher putChar(char c11) {
            this.update(2, c11);
            return this;
        }

        @Override
        public Hasher putString(CharSequence input, Charset charset) {
            if (Charsets.UTF_8.equals(charset)) {
                int utf16Length = input.length();
                int i11 = 0;
                while (i11 + 4 <= utf16Length) {
                    char c02 = input.charAt(i11);
                    char c12 = input.charAt(i11 + 1);
                    char c22 = input.charAt(i11 + 2);
                    char c32 = input.charAt(i11 + 3);
                    if (c02 >= '\u0080' || c12 >= '\u0080' || c22 >= '\u0080' || c32 >= '\u0080') break;
                    this.update(4, c02 | c12 << 8 | c22 << 16 | c32 << 24);
                    i11 += 4;
                }
                while (i11 < utf16Length) {
                    char c11 = input.charAt(i11);
                    if (c11 < '\u0080') {
                        this.update(1, c11);
                    } else if (c11 < '\u0800') {
                        this.update(2, Murmur3_32HashFunction.charToTwoUtf8Bytes(c11));
                    } else if (c11 < '\ud800' || c11 > '\udfff') {
                        this.update(3, Murmur3_32HashFunction.charToThreeUtf8Bytes(c11));
                    } else {
                        int codePoint = Character.codePointAt(input, i11);
                        if (codePoint == c11) {
                            this.putBytes(input.subSequence(i11, utf16Length).toString().getBytes(charset));
                            return this;
                        }
                        ++i11;
                        this.update(4, Murmur3_32HashFunction.codePointToFourUtf8Bytes(codePoint));
                    }
                    ++i11;
                }
                return this;
            }
            return super.putString(input, charset);
        }

        @Override
        public HashCode hash() {
            Preconditions.checkState(!this.isDone);
            this.isDone = true;
            this.h1 ^= Murmur3_32HashFunction.mixK1((int)this.buffer);
            return Murmur3_32HashFunction.fmix(this.h1, this.length);
        }
    }
}

