/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.sdkmodule;

import com.android.bundle.RuntimeEnabledSdkConfigProto;
import com.android.tools.build.bundletool.model.AndroidManifest;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.BundleModuleName;
import com.android.tools.build.bundletool.sdkmodule.AndroidResourceRenamer;
import com.android.tools.build.bundletool.sdkmodule.DexAndResourceRepackager;
import com.android.tools.build.bundletool.sdkmodule.ResourceTablePackageIdRemapper;
import com.android.tools.build.bundletool.sdkmodule.XmlPackageIdRemapper;

public final class SdkModuleToAppBundleModuleConverter {
    private final BundleModule sdkModule;
    private final ResourceTablePackageIdRemapper resourceTablePackageIdRemapper;
    private final XmlPackageIdRemapper xmlPackageIdRemapper;
    private final DexAndResourceRepackager dexAndResourceRepackager;
    private final AndroidResourceRenamer androidResourceRenamer;
    private final AndroidManifest appBaseModuleManifest;

    public SdkModuleToAppBundleModuleConverter(BundleModule sdkModule, RuntimeEnabledSdkConfigProto.RuntimeEnabledSdk sdkDependencyConfig, AndroidManifest appBaseModuleManifest) {
        this.sdkModule = sdkModule;
        this.resourceTablePackageIdRemapper = new ResourceTablePackageIdRemapper(sdkDependencyConfig.getResourcesPackageId());
        this.xmlPackageIdRemapper = new XmlPackageIdRemapper(sdkDependencyConfig.getResourcesPackageId());
        this.dexAndResourceRepackager = new DexAndResourceRepackager(sdkModule.getSdkModulesConfig().get(), sdkDependencyConfig);
        this.androidResourceRenamer = new AndroidResourceRenamer(sdkModule.getSdkModulesConfig().get());
        this.appBaseModuleManifest = appBaseModuleManifest;
    }

    public BundleModule convert() {
        return this.renameAndroidResources(this.repackageDexAndJavaResources(this.remapResourceIdsInResourceTable(this.remapResourceIdsInXmlResources(this.convertNameTypeAndManifest(this.sdkModule)))));
    }

    private BundleModule remapResourceIdsInResourceTable(BundleModule module) {
        return this.resourceTablePackageIdRemapper.remap(module);
    }

    private BundleModule remapResourceIdsInXmlResources(BundleModule module) {
        return this.xmlPackageIdRemapper.remap(module);
    }

    private BundleModule repackageDexAndJavaResources(BundleModule module) {
        return this.dexAndResourceRepackager.repackage(module);
    }

    private BundleModule renameAndroidResources(BundleModule module) {
        return this.androidResourceRenamer.renameAndroidResources(module);
    }

    private BundleModule convertNameTypeAndManifest(BundleModule module) {
        String sdkModuleName = this.sdkModule.getSdkModulesConfig().get().getSdkPackageName().replace(".", "");
        return module.toBuilder().setName(BundleModuleName.create(sdkModuleName)).setModuleType(BundleModule.ModuleType.SDK_DEPENDENCY_MODULE).setAndroidManifest(module.getAndroidManifest().toEditor().setPackage(this.appBaseModuleManifest.getPackageName()).setVersionCode(this.appBaseModuleManifest.getVersionCode().get()).removeUsesSdkElement().setMinSdkVersion(this.appBaseModuleManifest.getMinSdkVersion().get()).setHasCode(false).setSplitIdForFeatureSplit(sdkModuleName).setDeliveryOptionsForRuntimeEnabledSdkModule().save()).build();
    }
}

