/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleDeliveryType;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.splitters.ApkGenerationConfiguration;
import com.android.tools.build.bundletool.splitters.AssetModuleSplitter;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Optional;

public class AssetSlicesGenerator {
    private final AppBundle appBundle;
    private final ApkGenerationConfiguration apkGenerationConfiguration;
    private final Optional<Long> assetModulesVersionOverride;

    public AssetSlicesGenerator(AppBundle appBundle, ApkGenerationConfiguration apkGenerationConfiguration, Optional<Long> assetModulesVersionOverride) {
        this.appBundle = Preconditions.checkNotNull(appBundle);
        this.apkGenerationConfiguration = Preconditions.checkNotNull(apkGenerationConfiguration);
        this.assetModulesVersionOverride = assetModulesVersionOverride;
    }

    public ImmutableList<ModuleSplit> generateAssetSlices() {
        ImmutableList.Builder splits = ImmutableList.builder();
        Optional appVersionCode = this.appBundle.isAssetOnly() ? Optional.empty() : this.appBundle.getBaseModule().getAndroidManifest().getVersionCode();
        for (BundleModule module : this.appBundle.getAssetModules().values()) {
            AssetModuleSplitter moduleSplitter = new AssetModuleSplitter(module, this.apkGenerationConfiguration);
            splits.addAll((Iterable)moduleSplitter.splitModule().stream().map(split -> {
                if (module.getDeliveryType().equals((Object)ModuleDeliveryType.NO_INITIAL_INSTALL)) {
                    Optional<String> nonUpfrontAssetModulesVersionName = (this.assetModulesVersionOverride.isPresent() ? this.assetModulesVersionOverride : appVersionCode).map(rec$ -> rec$.toString());
                    return AssetSlicesGenerator.addVersionName(split, nonUpfrontAssetModulesVersionName);
                }
                return AssetSlicesGenerator.addVersionCode(split, appVersionCode);
            }).collect(ImmutableList.toImmutableList()));
        }
        return splits.build();
    }

    private static ModuleSplit addVersionCode(ModuleSplit moduleSplit, Optional<Integer> versionCode) {
        if (!versionCode.isPresent()) {
            return moduleSplit;
        }
        return moduleSplit.toBuilder().setAndroidManifest(moduleSplit.getAndroidManifest().toEditor().setVersionCode(versionCode.get()).save()).build();
    }

    private static ModuleSplit addVersionName(ModuleSplit moduleSplit, Optional<String> versionName) {
        if (!versionName.isPresent()) {
            return moduleSplit;
        }
        return moduleSplit.toBuilder().setAndroidManifest(moduleSplit.getAndroidManifest().toEditor().setVersionName(versionName.get()).save()).build();
    }
}

