/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.model;

import com.android.aapt.Resources;
import com.android.tools.build.bundletool.model.ModuleSplit;
import com.android.tools.build.bundletool.model.ResourceId;
import com.android.tools.build.bundletool.model.exceptions.CommandExecutionException;
import java.util.List;

public class ResourceInjector {
    private static final int BASE_RESOURCE_TABLE_PACKAGE_ID = 127;
    private static final String STRING_ENTRY_TYPE = "string";
    private static final String DRAWABLE_ENTRY_TYPE = "drawable";
    private static final String LAYOUT_ENTRY_TYPE = "layout";
    private final Resources.ResourceTable.Builder resourceTable;
    private final String packageName;

    public ResourceInjector(Resources.ResourceTable.Builder resourceTable, String packageName) {
        this.resourceTable = resourceTable;
        this.packageName = packageName;
    }

    public static ResourceInjector fromModuleSplit(ModuleSplit moduleSplit) {
        return new ResourceInjector(moduleSplit.getResourceTable().map(Resources.ResourceTable::toBuilder).orElseGet(Resources.ResourceTable::newBuilder), moduleSplit.getAndroidManifest().getPackageName());
    }

    public ResourceId addStringResource(String name, String value) {
        Resources.Entry resourceEntry = Resources.Entry.newBuilder().setName(name).addConfigValue(Resources.ConfigValue.newBuilder().setValue(Resources.Value.newBuilder().setItem(Resources.Item.newBuilder().setStr(Resources.String.newBuilder().setValue(value))))).build();
        return this.addResource(STRING_ENTRY_TYPE, resourceEntry);
    }

    public ResourceId addXmlDrawableResource(String drawableName, String fileReference) {
        Resources.Entry drawableEntity = Resources.Entry.newBuilder().setName(drawableName).addConfigValue(Resources.ConfigValue.newBuilder().setValue(Resources.Value.newBuilder().setItem(Resources.Item.newBuilder().setFile(Resources.FileReference.newBuilder().setPath(fileReference).setType(Resources.FileReference.Type.PROTO_XML))))).build();
        return this.addResource(DRAWABLE_ENTRY_TYPE, drawableEntity);
    }

    public ResourceId addLayoutResource(String layoutName, String fileReference) {
        Resources.Entry layoutEntry = Resources.Entry.newBuilder().setName(layoutName).addConfigValue(Resources.ConfigValue.newBuilder().setValue(Resources.Value.newBuilder().setItem(Resources.Item.newBuilder().setFile(Resources.FileReference.newBuilder().setPath(fileReference).setType(Resources.FileReference.Type.PROTO_XML))))).build();
        return this.addResource(LAYOUT_ENTRY_TYPE, layoutEntry);
    }

    public ResourceId addResource(String entryType, Resources.Entry entry) {
        ResourceId.Builder resourceIdBuilder = ResourceId.builder();
        Resources.Package.Builder packageBuilder = this.resourceTable.getPackageCount() == 0 ? this.resourceTable.addPackageBuilder().setPackageName(this.packageName).setPackageId(Resources.PackageId.newBuilder().setId(127)) : this.resourceTable.getPackageBuilder(0);
        resourceIdBuilder.setPackageId(packageBuilder.getPackageId().getId());
        ResourceInjector.addResourceToPackage(packageBuilder, resourceIdBuilder, entryType, entry);
        return resourceIdBuilder.build();
    }

    public Resources.ResourceTable build() {
        return this.resourceTable.build();
    }

    private static void addResourceToPackage(Resources.Package.Builder resourcePackage, ResourceId.Builder resourceId, String entryType, Resources.Entry entry) {
        Resources.Type.Builder type = resourcePackage.getTypeBuilderList().stream().filter(t11 -> t11.getName().equals(entryType)).findFirst().orElseGet(() -> resourcePackage.addTypeBuilder().setName(entryType).setTypeId(Resources.TypeId.newBuilder().setId(ResourceInjector.getNextTypeId(resourcePackage.getTypeList()))));
        resourceId.setTypeId(type.getTypeId().getId());
        ResourceInjector.addResourceToType(type, resourceId, entry);
    }

    private static void addResourceToType(Resources.Type.Builder type, ResourceId.Builder resourceId, Resources.Entry entry) {
        int nextEntryId = ResourceInjector.getNextEntryId(type.getEntryList());
        resourceId.setEntryId(nextEntryId);
        type.addEntry(entry.toBuilder().setEntryId(Resources.EntryId.newBuilder().setId(nextEntryId)));
    }

    private static int getNextEntryId(List<Resources.Entry> entryList) {
        int highestEntryId = entryList.stream().mapToInt(entry -> entry.getEntryId().getId()).max().orElse(-1);
        if (highestEntryId >= 65535) {
            throw CommandExecutionException.builder().withInternalMessage("No free entry id left in the resource table.").build();
        }
        return highestEntryId + 1;
    }

    private static int getNextTypeId(List<Resources.Type> typeList) {
        int highestTypeId = typeList.stream().mapToInt(type -> type.getTypeId().getId()).max().orElse(0);
        if (highestTypeId >= 255) {
            throw CommandExecutionException.builder().withInternalMessage("No free type id left in the resource table.").build();
        }
        return highestTypeId + 1;
    }
}

