/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.splitters;

import com.android.tools.build.bundletool.model.AppBundle;
import com.android.tools.build.bundletool.model.ModuleSplit;

public final class CodeTransparencyInjector {
    private final AppBundle appBundle;

    public CodeTransparencyInjector(AppBundle appBundle) {
        this.appBundle = appBundle;
    }

    public ModuleSplit inject(ModuleSplit split) {
        ModuleSplit.Builder splitBuilder = split.toBuilder();
        if (this.shouldPropagateTransparency(split)) {
            this.appBundle.getBundleMetadata().getModuleEntryForSignedTransparencyFile().ifPresent(splitBuilder::addEntry);
        }
        return splitBuilder.build();
    }

    private boolean shouldPropagateTransparency(ModuleSplit split) {
        if (split.getSplitType() == ModuleSplit.SplitType.STANDALONE) {
            return !this.appBundle.dexMergingEnabled();
        }
        return split.isMasterSplit() && split.isBaseModuleSplit();
    }
}

