/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.size;

import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Supplier;
import java.util.zip.Deflater;

final class ApkCompressedSizeCalculator {
    static final int DEFLATER_SYNC_OVERHEAD_BYTES = 5;
    private static final int INPUT_BUFFER_SIZE = 8192;
    private final Supplier<ApkGzipDeflater> deflaterSupplier;

    ApkCompressedSizeCalculator(Supplier<ApkGzipDeflater> deflaterSupplier) {
        this.deflaterSupplier = deflaterSupplier;
    }

    public ImmutableList<Long> calculateGZipSizeForEntries(List<ByteSource> byteSources) throws IOException {
        ImmutableList.Builder gzipSizeIncrements = ImmutableList.builder();
        try (ApkGzipDeflater deflater = this.deflaterSupplier.get();){
            byte[] inputBuffer = new byte[8192];
            block10: for (ByteSource byteSource : byteSources) {
                InputStream is2 = byteSource.openStream();
                try {
                    while (true) {
                        int r11;
                        if ((r11 = is2.read(inputBuffer)) == -1) {
                            gzipSizeIncrements.add((Object)Math.max(0L, deflater.entryComplete() - 5L));
                            continue block10;
                        }
                        deflater.handleInput(inputBuffer, r11);
                    }
                }
                finally {
                    if (is2 == null) continue;
                    is2.close();
                }
            }
        }
        return gzipSizeIncrements.build();
    }

    static final class JavaUtilZipDeflater
    implements ApkGzipDeflater {
        private final Deflater deflater;
        private final byte[] outputBuffer = new byte[16384];
        private long deflatedSize = 0L;

        public JavaUtilZipDeflater() {
            this.deflater = new Deflater(-1, true);
        }

        @Override
        public void handleInput(byte[] data, int size) {
            this.deflater.setInput(data, 0, size);
            while (!this.deflater.needsInput()) {
                this.deflatedSize += (long)this.deflater.deflate(this.outputBuffer, 0, this.outputBuffer.length, 0);
            }
        }

        @Override
        public long entryComplete() {
            long result = this.deflatedSize + (long)this.deflater.deflate(this.outputBuffer, 0, this.outputBuffer.length, 2);
            this.deflatedSize = 0L;
            return result;
        }

        @Override
        public void close() {
            this.deflater.end();
        }
    }

    static interface ApkGzipDeflater
    extends Closeable {
        public void handleInput(byte[] var1, int var2);

        public long entryComplete();
    }
}

